/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.tx;

import ch.bitagent.bitcoin.lib.wallet.AddressChangeIndex;
import org.json.JSONObject;

public class Utxo {
    private int txPos;
    private String txHash;
    private long value;
    private int height;
    private AddressChangeIndex changeIndex;

    public Utxo(JSONObject unspent, AddressChangeIndex changeIndex) {
        this.txPos = unspent.getInt("tx_pos");
        this.txHash = unspent.getString("tx_hash");
        this.value = unspent.getLong("value");
        this.height = unspent.getInt("height");
        this.changeIndex = changeIndex;
    }

    public int getTxPos() {
        return this.txPos;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public long getValue() {
        return this.value;
    }

    public int getHeight() {
        return this.height;
    }

    public AddressChangeIndex getChangeIndex() {
        return this.changeIndex;
    }

    public String toString() {
        return "Utxo{height=" + this.height + ", value=" + this.value + ", txPos=" + this.txPos + ", address='" + String.format("/%s/%s", this.changeIndex.getChange(), this.changeIndex.getIndex()) + "', txHash='" + this.txHash + "'}";
    }
}

