/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.helper.Helper;
import ch.bitagent.bitcoin.lib.helper.Properties;
import ch.bitagent.bitcoin.lib.helper.Tcp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Electrum {
    private static final Logger log = Logger.getLogger(Electrum.class.getSimpleName());
    private final List<String> sockets = new ArrayList<String>();

    public List<String> getSockets() {
        return this.sockets;
    }

    public String defaultSocket() {
        List<String> electrumRpcSockets = Properties.getElectrumRpcSockets();
        if (electrumRpcSockets.isEmpty()) {
            String error = "Please configure a default electrum rpc socket in bitcoinjavalib.properties";
            log.severe(error);
            throw new IllegalStateException(error);
        }
        String electrumRpcSocket = electrumRpcSockets.get(0);
        log.fine(electrumRpcSocket);
        this.sockets.clear();
        this.sockets.add(electrumRpcSocket);
        return electrumRpcSocket;
    }

    public void allSockets() {
        this.sockets.clear();
        for (String electrumRpcSocket : Properties.getElectrumRpcSockets()) {
            log.fine(electrumRpcSocket);
            this.sockets.add(electrumRpcSocket);
        }
    }

    public String callSocket(String socket, String jsonRequest) {
        long start = System.currentTimeMillis();
        try {
            if (socket == null) {
                socket = this.defaultSocket();
            }
            log.fine(String.format(">> %s", jsonRequest));
            String[] socketData = socket.split(":");
            if (socketData.length != 3) {
                throw new IllegalArgumentException("Invalid socket");
            }
            String host = socketData[0];
            int port = Integer.parseInt(socketData[1]);
            String protocol = socketData[2].toLowerCase();
            String jsonResponse = "tls".equals(protocol) ? Tcp.tlsSocket(host, port, jsonRequest) : ("ssl".equals(protocol) ? Tcp.sslSocket(host, port, jsonRequest) : Tcp.socket(host, port, jsonRequest));
            if (jsonResponse == null) {
                log.severe(String.format("jsonResponse == null\n%s %sms", socket, System.currentTimeMillis() - start));
                return null;
            }
            Object responseLog = jsonResponse.toString();
            if (((String)responseLog).length() > 80) {
                responseLog = ((String)responseLog).substring(0, 80) + " ...";
            }
            log.fine(String.format("<< %s", responseLog));
            log.info(String.format("%s %sms", socket, System.currentTimeMillis() - start));
            return jsonResponse;
        }
        catch (Exception e) {
            log.severe(String.format("%s\n%s %sms", e, socket, System.currentTimeMillis() - start));
            e.printStackTrace();
            return null;
        }
    }

    public List<JSONObject> ping() {
        ArrayList<JSONObject> pongs = new ArrayList<JSONObject>();
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, this.getJsonRequest("server.ping", null));
            if (jsonResponse == null || jsonResponse.isEmpty()) continue;
            pongs.add(new JSONObject(jsonResponse));
        }
        return pongs;
    }

    public List<JSONObject> features() {
        ArrayList<JSONObject> features = new ArrayList<JSONObject>();
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, this.getJsonRequest("server.features", null));
            JSONObject json = new JSONObject(jsonResponse);
            features.add(json.getJSONObject("result"));
        }
        return features;
    }

    public List<JSONArray> versions() {
        ArrayList<JSONArray> versions = new ArrayList<JSONArray>();
        for (String socket : this.sockets) {
            String jsonResponse = this.callSocket(socket, this.getJsonRequest("server.version", List.of("", "1.4")));
            JSONObject json = new JSONObject(jsonResponse);
            versions.add(json.getJSONArray("result"));
        }
        return versions;
    }

    public JSONArray peers() {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("server.peers.subscribe", null));
        JSONObject json = new JSONObject(jsonResponse);
        return json.getJSONArray("result");
    }

    public Integer height() {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.headers.subscribe", null));
        JSONObject json = new JSONObject(jsonResponse);
        return json.getJSONObject("result").getInt("height");
    }

    public JSONArray getHistory(String scripthash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.scripthash.get_history", List.of(scripthash)));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getJSONArray("result");
    }

    public JSONObject getBalance(String scripthash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.scripthash.get_balance", List.of(scripthash)));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getJSONObject("result");
    }

    public JSONArray getMempool(String scripthash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.scripthash.get_mempool", List.of(scripthash)));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getJSONArray("result");
    }

    public JSONArray listUnspent(String scripthash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.scripthash.listunspent", List.of(scripthash)));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getJSONArray("result");
    }

    public Long estimateFee(int number) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.estimatefee", List.of(String.valueOf(number))));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        double estimateFeeKB = json.getDouble("result");
        return Long.parseLong(Helper.btcToSat(estimateFeeKB / 1024.0)) + 1L;
    }

    public String getTransaction(String txHash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.transaction.get", List.of(txHash, Boolean.valueOf(false))));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getString("result");
    }

    public JSONObject getTransactionVerbose(String txHash) {
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.transaction.get", List.of(txHash, Boolean.valueOf(true))));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getJSONObject("result");
    }

    public String broadcastTransaction(String rawTx) {
        if (rawTx == null || rawTx.isEmpty()) {
            return null;
        }
        String jsonResponse = this.callSocket(null, this.getJsonRequest("blockchain.transaction.broadcast", List.of(rawTx)));
        if (jsonResponse == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonResponse);
        if (json.isNull("result")) {
            log.severe(json.toString());
            return null;
        }
        return json.getString("result");
    }

    private String getJsonRequest(String method, List<Object> params) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("jsonrpc", (Object)"2.0");
        jsonRequest.put("method", (Object)method);
        JSONArray paramsJson = new JSONArray();
        if (params != null) {
            for (Object param : params) {
                paramsJson.put(param);
            }
        }
        jsonRequest.put("params", (Object)paramsJson);
        jsonRequest.put("id", (Object)"bitcoinjavalib");
        return jsonRequest.toString();
    }
}

