/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.logging.Logger;

public class GetHeadersMessage
implements Message {
    private static final Logger log = Logger.getLogger(GetHeadersMessage.class.getSimpleName());
    public static final String COMMAND = "getheaders";
    private final Int version;
    private final Int numHashes;
    private final byte[] startBlock;
    private final byte[] endBlock;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public GetHeadersMessage(Int version, Int numHashes, byte[] startBlock, byte[] endBlock) {
        this.version = Objects.requireNonNullElse(version, Int.parse(70015));
        this.numHashes = Objects.requireNonNullElse(numHashes, Int.parse(1));
        this.startBlock = Objects.requireNonNullElseGet(startBlock, () -> {
            String error = "a start block is required";
            log.severe(error);
            throw new IllegalArgumentException(error);
        });
        this.endBlock = Objects.requireNonNullElseGet(endBlock, () -> Bytes.initFill(32, (byte)0));
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.version.toBytesLittleEndian(4));
        result.writeBytes(Varint.encode(this.numHashes));
        result.writeBytes(Bytes.changeOrder(this.startBlock));
        result.writeBytes(Bytes.changeOrder(this.endBlock));
        return result.toByteArray();
    }
}

