/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.ecc.PrivateKey;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.network.Electrum;
import ch.bitagent.bitcoin.lib.tx.Utxo;
import ch.bitagent.bitcoin.lib.wallet.Address;
import ch.bitagent.bitcoin.lib.wallet.AddressChangeIndex;
import ch.bitagent.bitcoin.lib.wallet.ExtendedKey;
import ch.bitagent.bitcoin.lib.wallet.Message;
import ch.bitagent.bitcoin.lib.wallet.MnemonicSentence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Wallet {
    private final ExtendedKey extendedKey;
    private final List<Address> addressList0 = new ArrayList<Address>();
    private final List<Address> addressList1 = new ArrayList<Address>();
    private final List<Utxo> utxoList = new ArrayList<Utxo>();

    public static String createMnemonic(int entropyStrength) {
        byte[] entropy = MnemonicSentence.generateEntropy(entropyStrength);
        return MnemonicSentence.entropyToMnemonic(entropy);
    }

    public Wallet(ExtendedKey extendedKey) {
        if (Arrays.compare(extendedKey.getPrefix(), ExtendedKey.PREFIX_ZPRV.toBytes()) != 0 && Arrays.compare(extendedKey.getPrefix(), ExtendedKey.PREFIX_ZPUB.toBytes()) != 0) {
            throw new IllegalArgumentException("Prefix not supported");
        }
        this.extendedKey = extendedKey;
        ExtendedKey extendedKey0 = this.extendedKey.derive(0);
        this.deriveAddresses(extendedKey0, 0, 0, 19, this.addressList0);
        ExtendedKey extendedKey1 = this.extendedKey.derive(1);
        this.deriveAddresses(extendedKey1, 1, 0, 9, this.addressList1);
    }

    public static Wallet parse(ExtendedKey extendedKey) {
        return new Wallet(extendedKey);
    }

    public static Wallet parse(String mnemonicSentence, String passphrase) {
        byte[] seed = MnemonicSentence.mnemonicToSeed(mnemonicSentence, passphrase);
        String zprv = MnemonicSentence.seedToExtendedKey(seed, ExtendedKey.PREFIX_ZPRV);
        ExtendedKey m = ExtendedKey.parse(zprv);
        ExtendedKey m84h0h0h = m.derive(84, true, false).derive(0, true, false).derive(0, true, false);
        return new Wallet(m84h0h0h);
    }

    private void deriveAddresses(ExtendedKey extendedKey, int change, int indexFrom, int indexTo, List<Address> addressList) {
        for (int i = indexFrom; i <= indexTo; ++i) {
            ExtendedKey extendedKeyi = extendedKey.derive(i);
            S256Point publicKeyi = ExtendedKey.isKeyPrivate(extendedKeyi.getPrefix()) ? PrivateKey.parse(extendedKeyi.getKey()).getPoint() : S256Point.parse(extendedKeyi.getKey());
            Address addressi = Address.parse(publicKeyi.addressBech32P2wpkh(false));
            addressi.setChangeIndex(new AddressChangeIndex(change, i));
            addressList.add(addressi);
        }
    }

    public void history() {
        Electrum electrum = new Electrum();
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.addAll(this.addressList0);
        addressList.addAll(this.addressList1);
        for (Address address : addressList) {
            JSONObject balance;
            String scripthash = address.electrumScripthash();
            JSONArray history = electrum.getHistory(scripthash);
            if (history == null) continue;
            address.setHistoryCount(history.length());
            if (history.isEmpty() || (balance = electrum.getBalance(scripthash)) == null) continue;
            address.setUnconfirmed(balance.getLong("unconfirmed"));
            address.setConfirmed(balance.getLong("confirmed"));
            if (address.getUnconfirmed() <= 0L && address.getConfirmed() <= 0L) continue;
            JSONArray unspent = electrum.listUnspent(address.electrumScripthash());
            for (int i = 0; i < unspent.length(); ++i) {
                this.utxoList.add(new Utxo(unspent.getJSONObject(i), address.getChangeIndex()));
            }
        }
    }

    public Address nextReceiveAddress() {
        for (Address address : this.addressList0) {
            if (address.getHistoryCount() != 0) continue;
            return address;
        }
        return null;
    }

    public Address nextChangeAddress() {
        for (Address address : this.addressList1) {
            if (address.getHistoryCount() != 0) continue;
            return address;
        }
        return null;
    }

    public PrivateKey getPrivateKeyForChangeIndex(AddressChangeIndex changeIndex) {
        if (ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix())) {
            return PrivateKey.parse(this.extendedKey.derive(changeIndex.getChange()).derive(changeIndex.getIndex()).getKey());
        }
        throw new IllegalArgumentException("Private key is not available");
    }

    public String signMessage(String address, String message) {
        if (ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix())) {
            for (int i = 0; i < this.addressList0.size(); ++i) {
                if (!this.addressList0.get(i).getAddressString().equals(address)) continue;
                ExtendedKey extendedKey0i = this.extendedKey.derive(0).derive(i);
                PrivateKey privateKey0i = PrivateKey.parse(extendedKey0i.getKey());
                return Message.sign(privateKey0i, message, "bech32", true);
            }
            throw new IllegalArgumentException("Address not found");
        }
        throw new IllegalArgumentException("Sign message with a public key not possible");
    }

    public boolean verifyMessage(String address, String signature, String message) {
        for (int i = 0; i < this.addressList0.size(); ++i) {
            if (!this.addressList0.get(i).getAddressString().equals(address)) continue;
            ExtendedKey extendedKey0i = this.extendedKey.derive(0).derive(i);
            S256Point publicKey0i = ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix()) ? PrivateKey.parse(extendedKey0i.getKey()).getPoint() : S256Point.parse(extendedKey0i.getKey());
            return Message.verify(publicKey0i, signature, message, true);
        }
        throw new IllegalArgumentException("Address not found");
    }

    public ExtendedKey getExtendedKey() {
        return this.extendedKey;
    }

    public List<Address> getAddressList0() {
        return this.addressList0;
    }

    public List<Address> getAddressList1() {
        return this.addressList1;
    }

    public List<Utxo> getUtxoList() {
        return this.utxoList;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.addAll(this.addressList0);
        addressList.addAll(this.addressList1);
        for (Address address : addressList) {
            string.append("\n");
            string.append(address);
        }
        return string.toString();
    }
}

