/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Properties {
    private static final Logger log = Logger.getLogger(Properties.class.getSimpleName());
    private static final String FILENAME = "bitcoinjavalib.properties";
    public static final String WALLET_FILENAME = "wallet.properties";
    private static final java.util.Properties bitcoinjavalibProperties = new java.util.Properties();
    private static final java.util.Properties walletProperties = new java.util.Properties();

    private Properties() {
    }

    private static String getPath(String filename) {
        return Thread.currentThread().getContextClassLoader().getResource("").getPath() + filename;
    }

    private static String getProperty(java.util.Properties properties, String filename, String property) {
        Object[] objectArray;
        String path = Properties.getPath(filename);
        FileInputStream fileInputStream = new FileInputStream(path);
        try {
            if (properties.isEmpty()) {
                properties.load(fileInputStream);
                for (Object keyObject : properties.keySet().stream().sorted().toArray()) {
                    String key = (String)keyObject;
                    log.fine(String.format("%s=%s", key, properties.getProperty(key)));
                }
            }
            objectArray = properties.getProperty(property);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                throw new IllegalStateException(e.getMessage());
            }
        }
        fileInputStream.close();
        return objectArray;
    }

    private static List<String> getPropertyList(java.util.Properties properties, String path, String property) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        String propertyI = Properties.getProperty(properties, path, property + i++);
        while (propertyI != null && !propertyI.isEmpty()) {
            list.add(propertyI);
            propertyI = Properties.getProperty(properties, path, property + i++);
        }
        return list;
    }

    public static String getBitcoinP2pUrl() {
        return Properties.getProperty(bitcoinjavalibProperties, FILENAME, "bitcoin.p2p.url");
    }

    public static String getBitcoinP2pHost() {
        return Properties.getBitcoinP2pUrl().split(":")[0];
    }

    public static Integer getBitcoinP2pPort() {
        return Integer.parseInt(Properties.getBitcoinP2pUrl().split(":")[1]);
    }

    public static Boolean getBitcoinP2pTestnet() {
        return Boolean.parseBoolean(Properties.getProperty(bitcoinjavalibProperties, FILENAME, "bitcoin.p2p.testnet"));
    }

    public static String getBitcoinRpcUrl() {
        return Properties.getProperty(bitcoinjavalibProperties, FILENAME, "bitcoin.rpc.url");
    }

    public static Boolean getBitcoinRpcTestnet() {
        return Boolean.parseBoolean(Properties.getProperty(bitcoinjavalibProperties, FILENAME, "bitcoin.rpc.testnet"));
    }

    public static String getBitcoinRpcAuth() {
        String auth = Properties.getProperty(bitcoinjavalibProperties, FILENAME, "bitcoin.rpc.auth");
        if (auth != null && !auth.trim().isEmpty()) {
            return auth;
        }
        return null;
    }

    public static String getBlockstreamMainnetUrl() {
        return Properties.getProperty(bitcoinjavalibProperties, FILENAME, "blockstream.mainnet.url");
    }

    public static String getBlockstreamTestnetUrl() {
        return Properties.getProperty(bitcoinjavalibProperties, FILENAME, "blockstream.testnet.url");
    }

    public static Boolean getTxFresh() {
        return Boolean.parseBoolean(Properties.getProperty(bitcoinjavalibProperties, FILENAME, "tx.fresh"));
    }

    public static String getTxCachefile() {
        return Properties.getProperty(bitcoinjavalibProperties, FILENAME, "tx.cachefile");
    }

    public static List<String> getElectrumRpcSockets() {
        return Properties.getPropertyList(bitcoinjavalibProperties, FILENAME, "electrum.rpc.socket.");
    }

    public static List<String> getWallets(String filename) {
        return Properties.getPropertyList(walletProperties, filename, "wallet.");
    }

    public static String getWalletMnemonic(String filename, int index) {
        List<String> wallet = Properties.getWallets(filename);
        if (wallet.size() > index) {
            String[] walletArray = wallet.get(index).split(":");
            return walletArray[0];
        }
        return null;
    }

    public static String getWalletPassphrase(String filename, int index) {
        String[] walletArray;
        List<String> wallet = Properties.getWallets(filename);
        if (wallet.size() > index && (walletArray = wallet.get(index).split(":")).length > 1) {
            return walletArray[1];
        }
        return null;
    }
}

