/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.GetDataType;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class GetDataMessage
implements Message {
    public static final String COMMAND = "getdata";
    private final List<GetDataType> data = new ArrayList<GetDataType>();

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public void addData(GetDataType data) {
        this.data.add(data);
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(Varint.encode(Int.parse(this.data.size())));
        for (GetDataType dataType : this.data) {
            result.writeBytes(Int.parse(dataType.getDataType()).toBytesLittleEndian(4));
            result.writeBytes(Bytes.changeOrder(dataType.getIdentifier()));
        }
        return result.toByteArray();
    }
}

