/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.script;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.ecc.Signature;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.logging.Logger;

public class Op {
    private static final Logger log = Logger.getLogger(Op.class.getSimpleName());

    private Op() {
    }

    static byte[] encodeNum(int num) {
        boolean negative;
        byte[] result = new byte[]{};
        if (num == 0) {
            return result;
        }
        boolean bl = negative = num < 0;
        for (int absNum = Math.abs(num); absNum != 0; absNum >>= 8) {
            result = Bytes.add(result, new byte[]{(byte)(absNum & 0xFF)});
        }
        if ((result[result.length - 1] & 0x80) != 0) {
            result = negative ? Bytes.add(result, new byte[]{-128}) : Bytes.add(result, new byte[]{0});
        } else if (negative) {
            int n = result.length - 1;
            result[n] = (byte)(result[n] | 0xFFFFFF80);
        }
        return result;
    }

    static int decodeNum(byte[] element) {
        int result;
        boolean negative;
        if (Arrays.equals(element, new byte[0])) {
            return 0;
        }
        byte[] bigEndian = Bytes.changeOrder(element);
        if ((bigEndian[0] & 0x80) != 0) {
            negative = true;
            result = bigEndian[0] & 0x7F;
        } else {
            negative = false;
            result = bigEndian[0];
        }
        for (int c = 1; c < bigEndian.length; ++c) {
            result <<= 8;
            result += c;
        }
        if (negative) {
            return -result;
        }
        return result;
    }

    public static boolean op0(Deque<byte[]> stack) {
        stack.push(Op.encodeNum(0));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op1(Deque<byte[]> stack) {
        stack.push(Op.encodeNum(1));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op2(Deque<byte[]> stack) {
        stack.push(Op.encodeNum(2));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op6(Deque<byte[]> stack) {
        stack.push(Op.encodeNum(6));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op105Verify(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        if (Op.decodeNum(element) == 0) {
            return false;
        }
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op1102Dup(Deque<byte[]> stack) {
        if (stack.size() < 2) {
            return false;
        }
        byte[] element1 = stack.pop();
        byte[] element2 = stack.pop();
        stack.push(element2);
        stack.push(element1);
        stack.push(element2);
        stack.push(element1);
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op118Dup(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        stack.push(element);
        stack.push(element);
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op124Swap(Deque<byte[]> stack) {
        if (stack.size() < 2) {
            return false;
        }
        byte[] element1 = stack.pop();
        byte[] element2 = stack.pop();
        stack.push(element1);
        stack.push(element2);
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op135Equal(Deque<byte[]> stack) {
        Hex element2;
        if (stack.size() < 2) {
            return false;
        }
        Hex element1 = Hex.parse(stack.pop());
        if (element1.eq(element2 = Hex.parse(stack.pop()))) {
            stack.push(Op.encodeNum(1));
        } else {
            stack.push(Op.encodeNum(0));
        }
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op136EqualVerify(Deque<byte[]> stack) {
        return Op.op135Equal(stack) && Op.op105Verify(stack);
    }

    public static boolean op145Not(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        if (Op.decodeNum(element) == 0) {
            stack.push(Op.encodeNum(1));
        } else {
            stack.push(Op.encodeNum(0));
        }
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    public static boolean op147Add(Deque<byte[]> stack) {
        if (stack.size() < 2) {
            return false;
        }
        Hex element1 = Hex.parse(stack.pop());
        Hex element2 = Hex.parse(stack.pop());
        stack.push(Op.encodeNum(element1.add(element2).intValue()));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op167Sha1(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        stack.push(Hash.sha1(element));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op169Hash160(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        stack.push(Hash.hash160(element));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op170Hash256(Deque<byte[]> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        byte[] element = stack.pop();
        stack.push(Hash.hash256(element));
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op172Checksig(Deque<byte[]> stack, Int z) {
        Signature sig;
        S256Point point;
        if (stack.size() < 2) {
            return false;
        }
        byte[] secPubkey = stack.pop();
        byte[] derSignatureWithHashType = stack.pop();
        byte[] derSignature = Arrays.copyOf(derSignatureWithHashType, derSignatureWithHashType.length - 1);
        try {
            point = S256Point.parse(secPubkey);
            sig = Signature.parse(derSignature);
        }
        catch (Exception e) {
            log.severe(String.format("Exception %s", e.getMessage()));
            return false;
        }
        if (point.verify(z, sig)) {
            stack.push(Op.encodeNum(1));
        } else {
            stack.push(Op.encodeNum(0));
        }
        log.fine(String.format("%s", Op.printStack(stack)));
        return true;
    }

    static boolean op174Checkmultisig(Deque<byte[]> stack, Int z) {
        Object derSignature;
        if (stack.isEmpty()) {
            return false;
        }
        int n = Op.decodeNum(stack.pop());
        if (stack.size() < n + 1) {
            return false;
        }
        ArrayList<byte[]> secPubkeys = new ArrayList<byte[]>();
        for (int i = 0; i < n; ++i) {
            secPubkeys.add(stack.pop());
        }
        int m = Op.decodeNum(stack.pop());
        if (stack.size() < m + 1) {
            return false;
        }
        ArrayList<byte[]> derSignatures = new ArrayList<byte[]>();
        for (int i = 0; i < m; ++i) {
            derSignature = stack.pop();
            derSignatures.add(Arrays.copyOf((byte[])derSignature, ((byte[])derSignature).length - 1));
        }
        stack.pop();
        ArrayList<S256Point> points = new ArrayList<S256Point>();
        derSignature = secPubkeys.iterator();
        while (derSignature.hasNext()) {
            byte[] secPubkey = (byte[])derSignature.next();
            points.add(S256Point.parse(secPubkey));
        }
        ArrayList<Signature> sigs = new ArrayList<Signature>();
        for (byte[] derSignature2 : derSignatures) {
            sigs.add(Signature.parse(derSignature2));
        }
        block4: for (Signature sig : sigs) {
            if (points.isEmpty()) {
                log.severe("signatures no good or not in right order");
                return false;
            }
            for (S256Point point : points) {
                points.remove(point);
                if (!point.verify(z, sig)) continue;
                continue block4;
            }
        }
        stack.add(Op.encodeNum(1));
        return true;
    }

    public static String printStack(Deque<byte[]> stack) {
        StringBuilder stackBuilder = new StringBuilder();
        stackBuilder.append("[");
        String sep = "";
        for (byte[] bytes : stack) {
            stackBuilder.append(sep);
            String hexString = Bytes.byteArrayToHexString(bytes);
            if (hexString.length() >= 10) {
                stackBuilder.append(Helper.maskString(hexString, 4));
            } else {
                stackBuilder.append(hexString);
            }
            sep = " : ";
        }
        stackBuilder.append("]");
        return stackBuilder.toString();
    }
}

