/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.tx;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.script.Script;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class TxOut {
    private static final Logger log = Logger.getLogger(TxOut.class.getSimpleName());
    private final Int amount;
    private final Script scriptPubkey;

    public TxOut(Int amount, Script scriptPubkey) {
        this.amount = amount;
        this.scriptPubkey = scriptPubkey;
        log.fine(this.toString());
    }

    public static TxOut parse(ByteArrayInputStream stream) {
        Hex amount = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 8)));
        Script scriptPubkey = Script.parse(stream);
        return new TxOut(amount, scriptPubkey);
    }

    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.getAmount().toBytesLittleEndian(8));
        result.writeBytes(this.getScriptPubkey().serialize());
        return result.toByteArray();
    }

    public String toString() {
        return String.format("txout %s:%s", this.amount.intValue(), this.scriptPubkey);
    }

    public Int getAmount() {
        return this.amount;
    }

    public Script getScriptPubkey() {
        return this.scriptPubkey;
    }
}

