/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.block;

import ch.bitagent.bitcoin.lib.block.MerkleTree;
import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MerkleBlock
implements Message {
    public static final String COMMAND = "merkleblock";
    private final Int version;
    private final byte[] prevBlock;
    private final byte[] merkleRoot;
    private final Int timestamp;
    private final byte[] bits;
    private final byte[] nonce;
    private final int total;
    private final List<byte[]> hashes;
    private final byte[] flags;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public MerkleBlock(Int version, byte[] prevBlock, byte[] merkleRoot, Int timestamp, byte[] bits, byte[] nonce, int total, List<byte[]> hashes, byte[] flags) {
        this.version = version;
        this.prevBlock = prevBlock;
        this.merkleRoot = merkleRoot;
        this.timestamp = timestamp;
        this.bits = bits;
        this.nonce = nonce;
        this.total = total;
        this.hashes = hashes;
        this.flags = flags;
    }

    public static MerkleBlock parse(ByteArrayInputStream stream) {
        Hex version = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        byte[] prevBlock = Bytes.changeOrder(Bytes.read(stream, 32));
        byte[] merkleRoot = Bytes.changeOrder(Bytes.read(stream, 32));
        Hex timestamp = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        byte[] bits = Bytes.read(stream, 4);
        byte[] nonce = Bytes.read(stream, 4);
        int total = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4))).intValue();
        Int numHashes = Varint.read(stream);
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        for (int i = 0; i < numHashes.intValue(); ++i) {
            hashes.add(Bytes.changeOrder(Bytes.read(stream, 32)));
        }
        Int flagsLength = Varint.read(stream);
        byte[] flags = Bytes.read(stream, flagsLength.intValue());
        return new MerkleBlock(version, prevBlock, merkleRoot, timestamp, bits, nonce, total, hashes, flags);
    }

    public boolean isValid() {
        byte[] flagBits = Bytes.bytesToBitField(this.flags);
        List<byte[]> myHashes = this.hashes.stream().map(Bytes::changeOrder).collect(Collectors.toList());
        MerkleTree merkleTree = new MerkleTree(this.total);
        merkleTree.populateTree(flagBits, myHashes);
        return Arrays.equals(Bytes.changeOrder(merkleTree.root()), this.merkleRoot);
    }

    @Override
    public byte[] serialize() {
        return new byte[0];
    }

    public Int getVersion() {
        return this.version;
    }

    public byte[] getMerkleRoot() {
        return this.merkleRoot;
    }

    public byte[] getPrevBlock() {
        return this.prevBlock;
    }

    public Int getTimestamp() {
        return this.timestamp;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public int getTotal() {
        return this.total;
    }

    public List<byte[]> getHashes() {
        return this.hashes;
    }

    public byte[] getFlags() {
        return this.flags;
    }
}

