/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.ecc;

import ch.bitagent.bitcoin.lib.ecc.FieldElement;
import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.Point;
import ch.bitagent.bitcoin.lib.ecc.S256Field;
import ch.bitagent.bitcoin.lib.ecc.Signature;
import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bech32;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.script.Script;
import java.util.Arrays;
import java.util.Objects;

public class S256Point
extends Point {
    public static final Int N = Hex.parse("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141");
    private static final Int GX = Hex.parse("79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798");
    private static final Int GY = Hex.parse("483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8");
    private static S256Point g;
    private static final Int A;
    private static final Int B;

    public S256Point(S256Field x, S256Field y) {
        super(x, y, new S256Field(A), new S256Field(B));
    }

    public static S256Point getG() {
        if (g == null) {
            g = new S256Point(new S256Field(GX), new S256Field(GY));
        }
        return g;
    }

    @Override
    public S256Point add(Point other) {
        Point point = super.add(other);
        if (point.getX() == null) {
            return null;
        }
        S256Field x = new S256Field(S256Point.getNum(point.getX()));
        S256Field y = new S256Field(S256Point.getNum(point.getY()));
        return new S256Point(x, y);
    }

    @Override
    public S256Point mul(Int coefficient) {
        Int coeff = coefficient.mod(N);
        Point point = super.mul(coeff);
        if (point.getX() == null && point.getY() == null) {
            return new S256Point(null, null);
        }
        if (point.getX() != null) {
            S256Field x = new S256Field(S256Point.getNum(point.getX()));
            S256Field y = new S256Field(S256Point.getNum(point.getY()));
            return new S256Point(x, y);
        }
        throw new IllegalStateException();
    }

    public boolean verify(Int z, Signature signature) {
        Int sInv = signature.getS().powMod(N.sub(Int.parse(2)), N);
        Int u = sInv.mul(z).mod(N);
        Int v = sInv.mul(signature.getR()).mod(N);
        S256Point total = S256Point.getG().mul(u).add(this.mul(v));
        return ((S256Field)total.getX()).num.eq(signature.getR());
    }

    public byte[] sec(Boolean compressed) {
        compressed = Objects.requireNonNullElse(compressed, true);
        byte[] x = ((S256Field)this.getX()).num.toBytes(32);
        if (Boolean.TRUE.equals(compressed)) {
            if (((S256Field)this.getY()).num.mod(Int.parse(2)).eq(Int.parse(0))) {
                return Bytes.add(new byte[]{2}, x);
            }
            return Bytes.add(new byte[]{3}, x);
        }
        return Bytes.add(new byte[][]{{4}, x, ((S256Field)this.getY()).num.toBytes(32)});
    }

    public byte[] hash160(Boolean compressed) {
        return Hash.hash160(this.sec(compressed));
    }

    public String address(Boolean compressed, boolean testnet) {
        byte[] h160 = this.hash160(compressed);
        byte prefix = testnet ? (byte)111 : 0;
        return Base58.encodeChecksum(Bytes.add(new byte[]{prefix}, h160));
    }

    public String addressBech32P2wpkh(boolean testnet) {
        Script script = Script.p2wpkhScript(this.hash160(true), true);
        return Bech32.encodeSegwit(testnet ? "tb" : "bc", script.toHex());
    }

    public static S256Point parse(byte[] secBin) {
        if (secBin[0] == 4) {
            Hex x = Hex.parse(Arrays.copyOfRange(secBin, 1, 33));
            Hex y = Hex.parse(Arrays.copyOfRange(secBin, 33, 65));
            return new S256Point(new S256Field(x), new S256Field(y));
        }
        if (secBin[0] == 2 || secBin[0] == 3) {
            boolean isEven;
            S256Field oddBeta;
            S256Field evenBeta;
            S256Field x = new S256Field(Hex.parse(Arrays.copyOfRange(secBin, 1, 33)));
            S256Field alpha = x.pow(Int.parse(3)).add(new S256Field(B));
            S256Field beta = alpha.sqrt();
            if (beta.num.mod(Int.parse(2)).eq(Int.parse(0))) {
                evenBeta = beta;
                oddBeta = new S256Field(S256Field.P.sub(beta.num));
            } else {
                evenBeta = new S256Field(S256Field.P.sub(beta.num));
                oddBeta = beta;
            }
            boolean bl = isEven = secBin[0] == 2;
            if (isEven) {
                return new S256Point(x, evenBeta);
            }
            return new S256Point(x, oddBeta);
        }
        throw new IllegalArgumentException("Invalid pubkey");
    }

    @Override
    public String toString() {
        if (this.getX() instanceof FieldElement && this.getY() instanceof FieldElement && this.getA() instanceof FieldElement && this.getB() instanceof FieldElement) {
            return String.format("S256Point(0x%s,0x%s)", S256Point.getNum(this.getX()).toHex(), S256Point.getNum(this.getY()).toHex());
        }
        if (this.getX() == null && this.getY() == null && this.getA() instanceof FieldElement && this.getB() instanceof FieldElement) {
            return "S256Point(infinity)";
        }
        return String.format("S256Point(%s,%s)_%s_%s", super.getX(), super.getY(), super.getA(), super.getB());
    }

    static {
        A = Int.parse(0);
        B = Int.parse(7);
    }
}

