/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.wallet.MnemonicSentence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Helper {
    private static final Logger log = Logger.getLogger(Helper.class.getSimpleName());

    private Helper() {
    }

    public static String zfill(int length, String bytes) {
        return String.format("%" + length + "s", bytes).replace(' ', '0');
    }

    public static String boolArrayToString(boolean[] boolArray) {
        StringBuilder string = new StringBuilder();
        for (boolean bool : boolArray) {
            string.append(bool ? "1" : "0");
        }
        return string.toString();
    }

    public static String maskString(String str, int len) {
        return str.substring(0, len) + ":" + str.substring(str.length() - len);
    }

    public static String btcToSat(double f) {
        return String.format("%8.0f", f * 1.0E8).trim();
    }

    public static double logWithBase(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static ArrayList<String> loadWordlist(String resource) {
        ArrayList<String> wordlist = new ArrayList<String>();
        try {
            InputStream inputStream = MnemonicSentence.class.getResourceAsStream(resource);
            if (inputStream == null) {
                throw new IllegalStateException("File not found.");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    wordlist.add(line);
                }
            }
        }
        catch (IOException e) {
            log.severe(e.getMessage());
        }
        return wordlist;
    }

    @Deprecated(since="0")
    public static String log(String string) {
        log.warning(String.format("%s (%s) %s", string, string.length()));
        return string;
    }
}

