/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.ecc;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.Point;
import ch.bitagent.bitcoin.lib.ecc.PointOperators;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import java.util.Arrays;

public class Schnorr {
    private static final int BYTES_LENGTH = 32;

    private Schnorr() {
    }

    public static byte[] getNumBytes(PointOperators po) {
        return Point.getNum(po).toBytes(32);
    }

    public static byte[] sign(byte[] msg, byte[] seckey, byte[] auxRand) {
        byte[] t;
        Int k0;
        Hex d0 = Hex.parse(seckey);
        if (d0.lt(Int.parse(1)) || d0.gt(S256Point.N.sub(Int.parse(1)))) {
            throw new IllegalArgumentException("The secret key must be an integer in the range 1..n-1.");
        }
        if (auxRand.length != 32) {
            throw new IllegalArgumentException(String.format("aux_rand must be %s bytes instead of %s.", 32, auxRand.length));
        }
        S256Point p = S256Point.getG().mul(d0);
        Int d = d0;
        if (!p.hasEvenY()) {
            d = S256Point.N.sub(d0);
        }
        if ((k0 = Hex.parse(Hash.taggedHash("BIP0340/nonce", Bytes.add(new byte[][]{t = Bytes.xor(d.toBytes(32), Hash.taggedHash("BIP0340/aux", auxRand)), Schnorr.getNumBytes(p.getX()), msg}))).mod(S256Point.N)).eq(Int.parse(0))) {
            throw new IllegalStateException("Failure. This happens only with negligible probability.");
        }
        S256Point r = S256Point.getG().mul(k0);
        Int k = k0;
        if (!r.hasEvenY()) {
            k = S256Point.N.sub(k0);
        }
        Int e = Hex.parse(Hash.taggedHash("BIP0340/challenge", Bytes.add(new byte[][]{Schnorr.getNumBytes(r.getX()), Schnorr.getNumBytes(p.getX()), msg}))).mod(S256Point.N);
        byte[] sig = Bytes.add(Schnorr.getNumBytes(r.getX()), e.mul(d).add(k).mod(S256Point.N).toBytes(32));
        if (!Schnorr.verify(msg, Schnorr.getNumBytes(p.getX()), sig)) {
            throw new IllegalStateException("The created signature does not pass verification.");
        }
        return sig;
    }

    public static boolean verify(byte[] msg, byte[] pubkey, byte[] sig) {
        if (pubkey.length != 32) {
            throw new IllegalArgumentException("'The public key must be a 32-byte array.'");
        }
        if (sig.length != 64) {
            throw new IllegalArgumentException("The signature must be a 64-byte array.");
        }
        S256Point p = S256Point.liftX(Hex.parse(pubkey));
        if (p == null) {
            return false;
        }
        Hex r = Hex.parse(Arrays.copyOfRange(sig, 0, 32));
        if (r.ge(S256Point.P)) {
            return false;
        }
        Hex s = Hex.parse(Arrays.copyOfRange(sig, 32, 64));
        if (s.ge(S256Point.N)) {
            return false;
        }
        Int e = Hex.parse(Hash.taggedHash("BIP0340/challenge", Bytes.add(new byte[][]{Arrays.copyOfRange(sig, 0, 32), pubkey, msg}))).mod(S256Point.N);
        S256Point rr = S256Point.getG().mul(s).add(p.mul(S256Point.N.sub(e)));
        if (rr == null) {
            return false;
        }
        if (!rr.hasEvenY()) {
            return false;
        }
        return !Point.getNum(rr.getX()).ne(r);
    }
}

