/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Ripemd160;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Hash {
    private static final Logger log = Logger.getLogger(Hash.class.getSimpleName());
    public static final Int SIGHASH_ALL = Int.parse(1);
    public static final Int SIGHASH_NONE = Int.parse(2);
    public static final Int SIGHASH_SINGLE = Int.parse(3);

    private Hash() {
    }

    private static byte[] ripemd160(byte[] bytes) {
        return Ripemd160.getHash(bytes);
    }

    public static byte[] sha1(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static byte[] sha256(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static byte[] hash160(byte[] bytes) {
        return Hash.ripemd160(Hash.sha256(bytes));
    }

    public static byte[] hash256(byte[] bytes) {
        return Hash.sha256(Hash.sha256(bytes));
    }

    public static Mac hmacS256Init(byte[] key) {
        try {
            String algorithm = "HmacSHA256";
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKeySpec);
            return mac;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static Mac hmacS512Init(byte[] key) {
        try {
            String algorithm = "HmacSHA512";
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKeySpec);
            return mac;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static byte[] taggedHash(String tag, byte[] msg) {
        byte[] tagHash = Hash.sha256(tag.getBytes());
        byte[] tagged = Bytes.add(new byte[][]{tagHash, tagHash, msg});
        return Hash.sha256(tagged);
    }
}

