/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import java.io.ByteArrayInputStream;

public class Varint {
    private Varint() {
    }

    public static Int read(ByteArrayInputStream stream) {
        byte bite = Bytes.read(stream, 1)[0];
        if (bite == -3) {
            return Hex.parse(Bytes.changeOrder(Bytes.read(stream, 2)));
        }
        if (bite == -2) {
            return Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        }
        if (bite == -1) {
            return Hex.parse(Bytes.changeOrder(Bytes.read(stream, 8)));
        }
        return Hex.parse(new byte[]{bite});
    }

    public static byte[] encode(Int i) {
        if (i.lt(Hex.parse("fd"))) {
            return i.toBytes(1);
        }
        if (i.lt(Hex.parse("10000"))) {
            return Bytes.add(new byte[]{-3}, i.toBytesLittleEndian(2));
        }
        if (i.lt(Hex.parse("100000000"))) {
            return Bytes.add(new byte[]{-2}, i.toBytesLittleEndian(4));
        }
        if (i.lt(Hex.parse("10000000000000000"))) {
            return Bytes.add(new byte[]{-1}, i.toBytesLittleEndian(8));
        }
        throw new IllegalArgumentException(String.format("Int too large: %s", i));
    }
}

