/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

public class NetworkEnvelope {
    private static final Logger log = Logger.getLogger(NetworkEnvelope.class.getSimpleName());
    private static final byte[] NETWORK_MAGIC = new byte[]{-7, -66, -76, -39};
    private static final byte[] TESTNET_NETWORK_MAGIC = new byte[]{11, 17, 9, 7};
    private final byte[] command;
    private final byte[] payload;
    private final Boolean testnet;
    private final byte[] magic;

    public NetworkEnvelope(byte[] command, byte[] payload, Boolean testnet) {
        this.command = command;
        this.payload = payload;
        this.testnet = Objects.requireNonNullElse(testnet, false);
        this.magic = Boolean.TRUE.equals(testnet) ? TESTNET_NETWORK_MAGIC : NETWORK_MAGIC;
    }

    public static int parseLength(ByteArrayInputStream stream) {
        Bytes.read(stream, 4);
        Bytes.read(stream, 12);
        Hex length = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        return length.intValue();
    }

    public static NetworkEnvelope parse(ByteArrayInputStream stream, Boolean testnet) {
        byte[] expectedMagic;
        byte[] magic = Bytes.read(stream, 4);
        if (Arrays.compare(magic, expectedMagic = Boolean.TRUE.equals(testnet) ? TESTNET_NETWORK_MAGIC : NETWORK_MAGIC) != 0) {
            String error = String.format("magic is not right %s vs %s", Hex.parse(magic), Hex.parse(expectedMagic));
            log.severe(error);
            throw new IllegalArgumentException(error);
        }
        byte[] command = Bytes.read(stream, 12);
        command = Bytes.strip(command, (byte)0);
        Hex payloadLength = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        byte[] checksum = Bytes.read(stream, 4);
        byte[] payload = Bytes.read(stream, payloadLength.intValue());
        byte[] calculatedChecksum = Arrays.copyOfRange(Hash.hash256(payload), 0, 4);
        if (Arrays.compare(calculatedChecksum, checksum) != 0) {
            throw new IllegalArgumentException(String.format("checksum does not match - expected %s - calculated %s - payload length %s", Hex.parse(checksum), Hex.parse(calculatedChecksum), payload.length));
        }
        log.fine(String.format("checksum match %s - payload length %s", Hex.parse(checksum), payload.length));
        return new NetworkEnvelope(command, payload, testnet);
    }

    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.magic);
        byte[] commandFiller = Bytes.initFill(12 - this.command.length, (byte)0);
        result.writeBytes(Bytes.add(this.command, commandFiller));
        result.writeBytes(Int.parse(this.payload.length).toBytesLittleEndian(4));
        result.writeBytes(Arrays.copyOfRange(Hash.hash256(this.payload), 0, 4));
        result.writeBytes(this.payload);
        return result.toByteArray();
    }

    public boolean isCommand(String command) {
        return Arrays.equals(this.command, command.getBytes());
    }

    public String toString() {
        return "NetworkEnvelope{command=" + Bytes.byteArrayToString(this.command) + ", payload=" + Hex.parse(this.payload) + ", testnet=" + this.testnet + ", magic=" + Hex.parse(this.magic) + "}";
    }

    public byte[] getCommand() {
        return this.command;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Boolean getTestnet() {
        return this.testnet;
    }

    public byte[] getMagic() {
        return this.magic;
    }
}

