/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.script;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Base58;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.script.Op;
import ch.bitagent.bitcoin.lib.script.OpCodeFunctions;
import ch.bitagent.bitcoin.lib.script.OpCodeNames;
import ch.bitagent.bitcoin.lib.script.ScriptCmd;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class Script {
    private static final Logger log = Logger.getLogger(Script.class.getSimpleName());
    private List<ScriptCmd> cmds = new ArrayList<ScriptCmd>();

    public static Script p2pkhScript(byte[] h160, boolean ... pushbytes) {
        ArrayList<ScriptCmd> cmds = new ArrayList<ScriptCmd>();
        cmds.add(OpCodeNames.OP_118_DUP.toScriptCmd());
        cmds.add(OpCodeNames.OP_169_HASH160.toScriptCmd());
        if (pushbytes.length > 0 && pushbytes[0]) {
            cmds.add(new ScriptCmd(Int.parse(h160.length).toBytes(1)));
        }
        cmds.add(new ScriptCmd(h160));
        cmds.add(OpCodeNames.OP_136_EQUALVERIFY.toScriptCmd());
        cmds.add(OpCodeNames.OP_172_CHECKSIG.toScriptCmd());
        return new Script(cmds);
    }

    public static Script p2shScript(byte[] h160, boolean ... pushbytes) {
        ArrayList<ScriptCmd> cmds = new ArrayList<ScriptCmd>();
        cmds.add(OpCodeNames.OP_169_HASH160.toScriptCmd());
        if (pushbytes.length > 0 && pushbytes[0]) {
            cmds.add(new ScriptCmd(Int.parse(h160.length).toBytes(1)));
        }
        cmds.add(new ScriptCmd(h160));
        cmds.add(OpCodeNames.OP_135_EQUAL.toScriptCmd());
        return new Script(cmds);
    }

    public static Script p2wpkhScript(byte[] h160, boolean ... pushbytes) {
        ArrayList<ScriptCmd> cmds = new ArrayList<ScriptCmd>();
        cmds.add(OpCodeNames.OP_0_0.toScriptCmd());
        if (pushbytes.length > 0 && pushbytes[0]) {
            cmds.add(new ScriptCmd(Int.parse(h160.length).toBytes(1)));
        }
        cmds.add(new ScriptCmd(h160));
        return new Script(cmds);
    }

    public static Script p2trScript(byte[] tweakedPubkey, boolean ... pushbytes) {
        ArrayList<ScriptCmd> cmds = new ArrayList<ScriptCmd>();
        cmds.add(OpCodeNames.OP_81_1.toScriptCmd());
        if (pushbytes.length > 0 && pushbytes[0]) {
            cmds.add(new ScriptCmd(Int.parse(tweakedPubkey.length).toBytes(1)));
        }
        cmds.add(new ScriptCmd(tweakedPubkey));
        return new Script(cmds);
    }

    public static Script opReturn(String data) {
        byte[] dataBytes = data.getBytes();
        if (dataBytes.length > 80) {
            throw new IllegalArgumentException();
        }
        return new Script(List.of(OpCodeNames.OP_106_RETURN.toScriptCmd(), new ScriptCmd(data.getBytes())));
    }

    public Script(List<ScriptCmd> cmds) {
        if (cmds != null && !cmds.isEmpty()) {
            this.cmds = cmds;
        }
    }

    public Script add(Script other) {
        ArrayList<ScriptCmd> cmdsAdd = new ArrayList<ScriptCmd>();
        cmdsAdd.addAll(this.cmds);
        cmdsAdd.addAll(other.cmds);
        return new Script(cmdsAdd);
    }

    public static Script parse(ByteArrayInputStream stream) {
        Int length = Varint.read(stream);
        ArrayList<ScriptCmd> cmds = new ArrayList<ScriptCmd>();
        int count = 0;
        while (count < length.intValue()) {
            Hex currentByte = Hex.parse(Bytes.read(stream, 1));
            ++count;
            if (currentByte.ge(Int.parse(1)) && currentByte.le(Int.parse(75))) {
                int n = currentByte.intValue();
                cmds.add(new ScriptCmd(Bytes.read(stream, n)));
                count += n;
                continue;
            }
            if (currentByte.eq(Int.parse(76))) {
                Hex dataLength = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 1)));
                cmds.add(new ScriptCmd(Bytes.read(stream, dataLength.intValue())));
                count += dataLength.intValue() + 1;
                continue;
            }
            if (currentByte.eq(Int.parse(77))) {
                Hex dataLength = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 2)));
                cmds.add(new ScriptCmd(Bytes.read(stream, dataLength.intValue())));
                count += dataLength.intValue() + 2;
                continue;
            }
            cmds.add(OpCodeNames.findByCode(currentByte).toScriptCmd());
        }
        if (count != length.intValue()) {
            String error = String.format("parsing script failed. count %s, length %s", count, length);
            log.severe(error);
            throw new IllegalStateException(error);
        }
        return new Script(cmds);
    }

    private byte[] rawSerialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        for (ScriptCmd cmd : this.cmds) {
            if (cmd.isOpCode()) {
                result.writeBytes(cmd.getOpCode().getCode().toBytesLittleEndian(1));
                continue;
            }
            if (cmd.isElement()) {
                int length = cmd.getElement().length;
                if (length < 75) {
                    result.writeBytes(Int.parse(length).toBytesLittleEndian(1));
                } else if (length > 75 && length < 256) {
                    result.writeBytes(Int.parse(76).toBytesLittleEndian(1));
                    result.writeBytes(Int.parse(length).toBytesLittleEndian(1));
                } else if (length >= 256 && length <= 520) {
                    result.writeBytes(Int.parse(77).toBytesLittleEndian(1));
                    result.writeBytes(Int.parse(length).toBytesLittleEndian(2));
                } else {
                    String error = String.format("too long cmd. length %s", length);
                    log.severe(error);
                    throw new IllegalStateException(error);
                }
                result.writeBytes(cmd.getElement());
                continue;
            }
            throw new IllegalStateException();
        }
        return result.toByteArray();
    }

    public byte[] serialize() {
        byte[] result = this.rawSerialize();
        Int total = Int.parse(result.length);
        byte[] totalVarint = Varint.encode(total);
        return Bytes.add(totalVarint, result);
    }

    public boolean evaluate(Int z, Script witness) {
        ArrayList<ScriptCmd> _cmds = new ArrayList<ScriptCmd>(this.cmds);
        ArrayDeque<byte[]> stack = new ArrayDeque<byte[]>();
        ArrayDeque<byte[]> altstack = new ArrayDeque<byte[]>();
        while (!_cmds.isEmpty()) {
            ScriptCmd cmd = _cmds.remove(0);
            if (cmd.isOpCode()) {
                boolean opResult = OpCodeFunctions.op(cmd.getOpCode(), stack, altstack, _cmds, z);
                if (opResult) continue;
                log.warning(String.format("bad op: %s", new Object[]{cmd.getOpCode()}));
                return false;
            }
            if (cmd.isElement()) {
                stack.push(cmd.getElement());
                if (new Script(_cmds).isP2shScriptPubkey()) {
                    _cmds.remove(0);
                    ScriptCmd h160 = _cmds.remove(0);
                    _cmds.remove(0);
                    if (!Op.op169Hash160(stack)) {
                        return false;
                    }
                    stack.push(h160.getElement());
                    if (!Op.op135Equal(stack)) {
                        return false;
                    }
                    if (!Op.op105Verify(stack)) {
                        log.severe("bad p2sh h160");
                        return false;
                    }
                    byte[] redeemScript = Bytes.add(Varint.encode(Int.parse(cmd.getElement().length)), cmd.getElement());
                    ByteArrayInputStream stream = new ByteArrayInputStream(redeemScript);
                    _cmds.addAll(Script.parse((ByteArrayInputStream)stream).cmds);
                    continue;
                }
                if (this.isP2wpkhStack(stack)) {
                    byte[] h160 = stack.pop();
                    stack.pop();
                    _cmds.addAll(witness.getCmds());
                    _cmds.addAll(Script.p2pkhScript(h160, new boolean[0]).getCmds());
                    continue;
                }
                if (!this.isP2wshStack(stack)) continue;
                byte[] s256 = stack.pop();
                stack.pop();
                ScriptCmd witnessScript = witness.getCmds().remove(witness.getCmds().size() - 1);
                _cmds.addAll(witness.getCmds());
                byte[] witnessScriptSha256 = Hash.sha256(witnessScript.getElement());
                if (!Arrays.equals(s256, witnessScriptSha256)) {
                    log.severe(String.format("bad sha256 %s vs %s", Hex.parse(s256), Hex.parse(witnessScriptSha256)));
                    return false;
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(Bytes.add(Varint.encode(Int.parse(witnessScript.getElement().length)), witnessScript.getElement()));
                List<ScriptCmd> witnessScriptCmds = Script.parse(stream).getCmds();
                _cmds.addAll(witnessScriptCmds);
                continue;
            }
            throw new IllegalStateException();
        }
        if (stack.isEmpty()) {
            log.warning("stack is empty.");
            return false;
        }
        if (Arrays.equals((byte[])stack.pop(), new byte[0])) {
            log.warning("stack is zero.");
            return false;
        }
        return true;
    }

    public boolean isP2pkhScriptPubkey() {
        return this.cmds.size() == 5 && OpCodeNames.OP_118_DUP.equals((Object)this.cmds.get(0).getOpCode()) && OpCodeNames.OP_169_HASH160.equals((Object)this.cmds.get(1).getOpCode()) && this.cmds.get(2).isElement() && this.cmds.get(2).getElement().length == 20 && OpCodeNames.OP_136_EQUALVERIFY.equals((Object)this.cmds.get(3).getOpCode()) && OpCodeNames.OP_172_CHECKSIG.equals((Object)this.cmds.get(4).getOpCode());
    }

    public boolean isP2shScriptPubkey() {
        return this.cmds.size() == 3 && OpCodeNames.OP_169_HASH160.equals((Object)this.cmds.get(0).getOpCode()) && this.cmds.get(1).isElement() && this.cmds.get(1).getElement().length == 20 && OpCodeNames.OP_135_EQUAL.equals((Object)this.cmds.get(2).getOpCode());
    }

    public boolean isP2wpkhScriptPubkey() {
        return this.cmds.size() == 2 && OpCodeNames.OP_0_0.equals((Object)this.cmds.get(0).getOpCode()) && this.cmds.get(1).isElement() && this.cmds.get(1).getElement().length == 20;
    }

    public boolean isP2wpkhStack(Deque<byte[]> stack) {
        if (stack.size() == 2) {
            byte[] stack1 = stack.pop();
            byte[] stack0 = stack.pop();
            stack.push(stack0);
            stack.push(stack1);
            if (OpCodeNames.OP_0_0.getCode().equals(Hex.parse(stack0)) && stack1.length == 20) {
                return true;
            }
        }
        return false;
    }

    public boolean isP2wshScriptPubkey() {
        return this.cmds.size() == 2 && OpCodeNames.OP_0_0.equals((Object)this.cmds.get(0).getOpCode()) && this.cmds.get(1).isElement() && this.cmds.get(1).getElement().length == 32;
    }

    public boolean isP2wshStack(Deque<byte[]> stack) {
        if (stack.size() == 2) {
            byte[] stack1 = stack.pop();
            byte[] stack0 = stack.pop();
            stack.push(stack0);
            stack.push(stack1);
            if (OpCodeNames.OP_0_0.getCode().equals(Hex.parse(stack0)) && stack1.length == 32) {
                return true;
            }
        }
        return false;
    }

    public String address(Boolean testnet) {
        testnet = Objects.requireNonNullElse(testnet, false);
        if (this.isP2pkhScriptPubkey()) {
            byte[] h160 = this.getCmds().get(2).getElement();
            return Base58.h160toP2pkhAddress(h160, testnet);
        }
        if (this.isP2shScriptPubkey()) {
            byte[] h160 = this.getCmds().get(1).getElement();
            return Base58.h160toP2shAddress(h160, testnet);
        }
        String error = String.format("Unknown ScriptPubKey %s", this);
        log.severe(error);
        throw new IllegalStateException(error);
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        for (ScriptCmd cmd : this.cmds) {
            if (cmd.isOpCode()) {
                result.add(cmd.getOpCode().getCodeName());
                continue;
            }
            if (cmd.isElement()) {
                result.add(cmd.getElementAsHexString());
                continue;
            }
            throw new IllegalStateException();
        }
        return String.join((CharSequence)" ", result);
    }

    public String toHex() {
        ArrayList<String> result = new ArrayList<String>();
        for (ScriptCmd cmd : this.cmds) {
            if (cmd.isOpCode()) {
                result.add(cmd.getOpCode().getCode().toString());
                continue;
            }
            if (cmd.isElement()) {
                result.add(cmd.getElementAsHexString());
                continue;
            }
            throw new IllegalStateException();
        }
        return String.join((CharSequence)"", result);
    }

    public List<ScriptCmd> getCmds() {
        return this.cmds;
    }
}

