/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.ecc.PrivateKey;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.ecc.Signature;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Varint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Logger;

public class Message {
    private static final Logger log = Logger.getLogger(Message.class.getSimpleName());
    private static final String BITCOIN_SIGNED_MESSAGE_HEADER = "Bitcoin Signed Message:\n";

    private Message() {
    }

    public static String sign(PrivateKey privateKey, String message, String addressType, boolean electrum) {
        byte[] messageFormatted = Message.formatMessageForSigning(message);
        Hex z = Hex.parse(Hash.hash256(messageFormatted));
        int counter = 0;
        Signature signature = privateKey.sign(z, counter);
        while (signature.der().length >= 71) {
            signature = privateKey.sign(z, ++counter);
        }
        byte recoveryId = Message.findRecoveryId(z, signature, privateKey.getPoint());
        if (electrum) {
            recoveryId = (byte)(recoveryId - 8);
        }
        int headerByte = recoveryId + Message.getSigningTypeConstant(addressType);
        byte[] sigData = new byte[65];
        sigData[0] = (byte)headerByte;
        System.arraycopy(signature.getR().toBytes(32), 0, sigData, 1, 32);
        System.arraycopy(signature.getS().toBytes(32), 0, sigData, 33, 32);
        return new String(Base64.getEncoder().encode(sigData));
    }

    public static boolean verify(S256Point publicKey, String signatureB64, String message, boolean electrum) {
        byte[] signatureDecoded = Base64.getDecoder().decode(signatureB64);
        byte[] messageFormatted = Message.formatMessageForSigning(message);
        Hex z = Hex.parse(Hash.hash256(messageFormatted));
        if (signatureDecoded.length < 65) {
            throw new IllegalArgumentException("Signature truncated, expected 65 bytes and got " + signatureDecoded.length);
        }
        int header = signatureDecoded[0] & 0xFF;
        if (header < 27 || header > 42) {
            throw new IllegalArgumentException("Header byte out of range: " + header);
        }
        Hex r = Hex.parse(Arrays.copyOfRange(signatureDecoded, 1, 33));
        Hex s = Hex.parse(Arrays.copyOfRange(signatureDecoded, 33, 65));
        Signature signature = new Signature(r, s);
        if (header >= 39) {
            header -= 12;
        } else if (header >= 35 && !electrum) {
            header -= 8;
        } else if (header >= 31) {
            header -= 4;
        }
        int recoveryId = header - 27;
        S256Point key = Message.recoverFromSignature(recoveryId, signature, z);
        if (key == null) {
            throw new IllegalArgumentException("Could not recover public key from signature");
        }
        return key.eq(publicKey);
    }

    private static byte[] formatMessageForSigning(String message) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(BITCOIN_SIGNED_MESSAGE_HEADER.getBytes().length);
            bos.write(BITCOIN_SIGNED_MESSAGE_HEADER.getBytes());
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            byte[] size = Varint.encode(Int.parse(messageBytes.length));
            bos.write(size);
            bos.write(messageBytes);
            return bos.toByteArray();
        }
        catch (IOException e) {
            log.severe(e.getMessage());
            return new byte[0];
        }
    }

    private static byte findRecoveryId(Int message, Signature sig, S256Point p) {
        int recId = -1;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            S256Point k = Message.recoverFromSignature(i, sig, message);
            if (k == null || !k.eq(p)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new IllegalStateException("Could not construct a recoverable key. This should never happen.");
        }
        return (byte)recId;
    }

    private static S256Point recoverFromSignature(int recId, Signature sig, Int message) {
        Int prime;
        if (recId < 0) {
            throw new IllegalArgumentException("recId must be positive");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        Int n = S256Point.N;
        Int i = Int.parse(recId / 2);
        Int x = sig.getR().add(i.mul(n));
        if (x.ge(prime = S256Point.P)) {
            return null;
        }
        S256Point R = Message.decompressKey(x, (recId & 1) == 1);
        if (R.mul(n).getX() != null) {
            return null;
        }
        Int e = message;
        Int eInv = Int.parse(0).sub(e).mod(n);
        Int rInv = Int.parse(sig.getR().bigInt().modInverse(n.bigInt()));
        Int srInv = rInv.mul(sig.getS()).mod(n);
        Int eInvrInv = rInv.mul(eInv).mod(n);
        S256Point q1 = R.mul(srInv);
        S256Point q2 = S256Point.getG().mul(eInvrInv);
        return q1.add(q2);
    }

    private static S256Point decompressKey(Int xBN, boolean yBit) {
        byte[] compEnc = xBN.toBytes(33);
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return S256Point.parse(compEnc);
    }

    private static int getSigningTypeConstant(String addressType) {
        if ("p2pkh".equalsIgnoreCase(addressType)) {
            return 31;
        }
        if ("p2sh".equalsIgnoreCase(addressType)) {
            return 35;
        }
        if ("bech32".equalsIgnoreCase(addressType)) {
            return 39;
        }
        throw new IllegalArgumentException("Address type " + addressType + " is not supported for message signing");
    }
}

