/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.block;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Murmur3;
import ch.bitagent.bitcoin.lib.helper.Varint;
import ch.bitagent.bitcoin.lib.network.GenericMessage;
import java.io.ByteArrayOutputStream;
import java.util.Objects;

public class BloomFilter {
    public static final Int BIP37_CONSTANT = Hex.parse("fba4c795");
    private final int size;
    private final byte[] bitField;
    private final int functionCount;
    private final int tweak;

    public BloomFilter(int size, int functionCount, int tweak) {
        this.size = size;
        this.bitField = Bytes.initFill(this.size * 8, (byte)0);
        this.functionCount = functionCount;
        this.tweak = tweak;
    }

    public void add(byte[] item) {
        for (int i = 0; i < this.functionCount; ++i) {
            Int seed = Int.parse(i).mul(BIP37_CONSTANT).add(Int.parse(this.tweak));
            Int h = Murmur3.hash32(item, seed);
            int bit = h.mod(Int.parse(this.size * 8)).intValue();
            this.bitField[bit] = 1;
        }
    }

    public byte[] filterBytes() {
        return Bytes.bitFieldToBytes(this.bitField);
    }

    public GenericMessage filterload(Int flag) {
        flag = Objects.requireNonNullElse(flag, Int.parse(1));
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        payload.writeBytes(Varint.encode(Int.parse(this.size)));
        payload.writeBytes(this.filterBytes());
        payload.writeBytes(Int.parse(this.functionCount).toBytesLittleEndian(4));
        payload.writeBytes(Int.parse(this.tweak).toBytesLittleEndian(4));
        payload.writeBytes(flag.toBytesLittleEndian(1));
        return new GenericMessage("filterload", payload.toByteArray());
    }
}

