/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.block;

import ch.bitagent.bitcoin.lib.block.MerkleTreeLevel;
import ch.bitagent.bitcoin.lib.helper.Helper;
import ch.bitagent.bitcoin.lib.helper.Merkle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MerkleTree {
    Logger log = Logger.getLogger(MerkleTree.class.getSimpleName());
    private final int total;
    private final int maxDepth;
    private final List<MerkleTreeLevel> nodes;
    private int currentDepth;
    private int currentIndex;

    public MerkleTree(int total) {
        this.total = total;
        this.maxDepth = (int)Math.ceil(Helper.logWithBase(total, 2.0));
        this.nodes = new ArrayList<MerkleTreeLevel>();
        for (int depth = 0; depth < this.maxDepth + 1; ++depth) {
            int numItems = (int)Math.ceil((double)total / Math.pow(2.0, this.maxDepth - depth));
            MerkleTreeLevel levelHashes = new MerkleTreeLevel(numItems);
            this.nodes.add(levelHashes);
        }
        this.currentDepth = 0;
        this.currentIndex = 0;
    }

    public void up() {
        --this.currentDepth;
        this.currentIndex /= 2;
    }

    public void left() {
        ++this.currentDepth;
        this.currentIndex *= 2;
    }

    public void right() {
        ++this.currentDepth;
        this.currentIndex = this.currentIndex * 2 + 1;
    }

    public byte[] root() {
        return this.nodes.get(0).getItems().get(0);
    }

    public void setCurrentNode(byte[] value) {
        this.getNodes().get(this.currentDepth).getItems().set(this.currentIndex, value);
    }

    public byte[] getCurrentNode() {
        return this.getNodes().get(this.currentDepth).getItems().get(this.currentIndex);
    }

    public byte[] getLeftNode() {
        return this.getNodes().get(this.currentDepth + 1).getItems().get(this.currentIndex * 2);
    }

    public byte[] getRightNode() {
        return this.getNodes().get(this.currentDepth + 1).getItems().get(this.currentIndex * 2 + 1);
    }

    public boolean isLeaf() {
        return this.currentDepth == this.maxDepth;
    }

    public boolean rightExists() {
        return this.getNodes().get(this.currentDepth + 1).getItems().size() > this.currentIndex * 2 + 1;
    }

    public void populateTree(byte[] flagBits, List<byte[]> hashes) {
        ArrayDeque<Byte> flagBitsQueue = new ArrayDeque<Byte>();
        for (int i = flagBits.length - 1; i >= 0; --i) {
            flagBitsQueue.push(flagBits[i]);
        }
        ArrayDeque<byte[]> hashesQueue = new ArrayDeque<byte[]>(hashes);
        while (this.root() == null) {
            if (this.isLeaf()) {
                flagBitsQueue.pop();
                this.setCurrentNode((byte[])hashesQueue.pop());
                this.up();
                continue;
            }
            byte[] leftHash = this.getLeftNode();
            if (leftHash == null) {
                if ((Byte)flagBitsQueue.pop() == 0) {
                    this.setCurrentNode((byte[])hashesQueue.pop());
                    this.up();
                    continue;
                }
                this.left();
                continue;
            }
            if (this.rightExists()) {
                byte[] rightHash = this.getRightNode();
                if (rightHash == null) {
                    this.right();
                    continue;
                }
                this.setCurrentNode(Merkle.merkleParent(leftHash, rightHash));
                this.up();
                continue;
            }
            this.setCurrentNode(Merkle.merkleParent(leftHash, leftHash));
            this.up();
        }
        if (!hashesQueue.isEmpty()) {
            String error = String.format("hashes not all consumed %s", hashesQueue.size());
            this.log.severe(error);
            throw new IllegalArgumentException(error);
        }
        for (Byte flagBit : flagBitsQueue) {
            if (flagBit == 0) continue;
            String error = "flag bits not all consumed'";
            this.log.severe(error);
            throw new IllegalArgumentException(error);
        }
    }

    public String toString() {
        return "MerkleTree{total=" + this.total + ", maxDepth=" + this.maxDepth + ", nodes=" + String.valueOf(this.nodes) + ", currentDepth=" + this.currentDepth + ", currentIndex=" + this.currentIndex + "}";
    }

    public List<MerkleTreeLevel> getNodes() {
        return this.nodes;
    }
}

