/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.ecc;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.ecc.Schnorr;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;

public class Taproot {
    private Taproot() {
    }

    public static byte[] tweakPubkey(byte[] pubkey, byte[] h) {
        byte[] taggedHash = Hash.taggedHash("TapTweak", Bytes.add(pubkey, h));
        Hex t = Hex.parse(taggedHash);
        if (t.ge(S256Point.P)) {
            throw new IllegalStateException();
        }
        S256Point P = S256Point.liftX(Hex.parse(pubkey));
        if (P == null) {
            throw new IllegalStateException();
        }
        S256Point Q = P.add(S256Point.getG().mul(t));
        if (Q.hasEvenY()) {
            return new byte[0];
        }
        return Schnorr.getNumBytes(Q.getX());
    }
}

