/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.helper.Bytes;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.logging.Logger;

public class Bech32 {
    private static final Logger log = Logger.getLogger(Bech32.class.getSimpleName());
    private static final int BECH32_CONST = 1;
    private static final int BECH32M_CONST = 734539939;
    private static final String BECH32_ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] BECH32_ALPHABET_DEC = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};

    private Bech32() {
    }

    private static byte[] getBech32AlphabetIndex(String rawData) {
        byte[] indexArray = new byte[rawData.length()];
        for (int i = 0; i < indexArray.length; ++i) {
            char indexChar = rawData.charAt(i);
            byte index = (byte)BECH32_ALPHABET.indexOf(indexChar);
            if (index == -1) {
                throw new IllegalArgumentException(String.format("Invalid data index character %s", (byte)indexChar));
            }
            indexArray[i] = index;
        }
        return indexArray;
    }

    private static byte[] getBech32AlphabetValue(byte[] rawData) {
        byte[] valueArray = new byte[rawData.length];
        for (int i = 0; i < valueArray.length; ++i) {
            byte valueChar = rawData[i];
            byte value = BECH32_ALPHABET.getBytes()[valueChar];
            if (value == -1) {
                throw new IllegalArgumentException(String.format("Invalid data value character %s", valueChar));
            }
            valueArray[i] = value;
        }
        return valueArray;
    }

    private static byte[] getBech32AlphabetDecodingValue(String rawData) {
        byte[] valueArray = new byte[rawData.length()];
        for (int i = 0; i < valueArray.length; ++i) {
            byte valueChar = (byte)rawData.charAt(i);
            byte value = BECH32_ALPHABET_DEC[valueChar];
            if (value == -1) {
                throw new IllegalArgumentException(String.format("Invalid decoding data value character %s", valueChar));
            }
            valueArray[i] = value;
        }
        return valueArray;
    }

    private static int polymod(byte[] values) {
        int[] gen = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
        int chk = 1;
        for (byte value : values) {
            int b = chk >> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ value & 0xFF;
            for (int i = 0; i < 5; ++i) {
                if ((b >> i & 1) == 0) continue;
                chk ^= gen[i];
            }
        }
        return chk;
    }

    private static byte[] hrpExpand(String hrp) {
        char[] hrpArray = hrp.toCharArray();
        int hrpLength = hrp.length();
        int hrpExpandLength = 1 + hrpLength;
        byte[] hrpExpanded = new byte[hrpLength + hrpExpandLength];
        hrpExpanded[hrpLength] = 0;
        for (int i = 0; i < hrpLength; ++i) {
            hrpExpanded[i] = (byte)(hrpArray[i] >> 5);
            hrpExpanded[i + hrpExpandLength] = (byte)(hrpArray[i] & 0x1F);
        }
        return hrpExpanded;
    }

    private static Encoding verifyChecksum(String hrp, byte[] bytes) {
        byte[] hrpExpanded = Bech32.hrpExpand(hrp);
        int polymod = Bech32.polymod(Bytes.add(hrpExpanded, bytes));
        if (polymod == 1) {
            return Encoding.BECH32;
        }
        if (polymod == 734539939) {
            return Encoding.BECH32M;
        }
        return null;
    }

    private static byte[] createChecksum(String hrp, byte[] bytes, Encoding encoding) {
        byte[] values = Bytes.add(Bech32.hrpExpand(hrp), bytes);
        int polymod = Bech32.polymod(Bytes.add(values, new byte[]{0, 0, 0, 0, 0, 0})) ^ (encoding.equals((Object)Encoding.BECH32) ? 1 : 734539939);
        byte[] checksum = new byte[6];
        for (int i = 0; i < 6; ++i) {
            checksum[i] = (byte)(polymod >> 5 * (5 - i) & 0x1F);
        }
        return checksum;
    }

    public static Encoding verify(String bech32) {
        try {
            String bech32Low = bech32.toLowerCase();
            if (bech32Low.length() > 90 && !bech32Low.startsWith("lnurl")) {
                throw new IllegalArgumentException(String.format("overall max length (90) exceeded %s", bech32.length()));
            }
            int lastIndex = bech32Low.lastIndexOf("1");
            if (lastIndex == -1) {
                throw new IllegalArgumentException("No separator character 1");
            }
            String hrp = bech32Low.substring(0, lastIndex);
            if (hrp.isEmpty()) {
                throw new IllegalArgumentException("Empty HRP");
            }
            for (int i = 0; i < hrp.length(); ++i) {
                byte hrpChar = (byte)hrp.charAt(i);
                if (hrpChar >= 33 && hrpChar <= 126) continue;
                throw new IllegalArgumentException(String.format("HRP character out of range [33-126]. %s", hrpChar));
            }
            String rawData = bech32Low.substring(lastIndex + 1);
            if (rawData.length() < 6) {
                throw new IllegalArgumentException(String.format("Too short checksum %s", rawData.length()));
            }
            Encoding verify = Bech32.verifyChecksum(hrp, Bech32.getBech32AlphabetIndex(rawData));
            if (verify == null) {
                throw new IllegalArgumentException(String.format("Bech32 checksum not valid %s", bech32));
            }
            return verify;
        }
        catch (Exception e) {
            log.fine(e.getMessage());
            return null;
        }
    }

    public static Bech32Data decode(String bech32) {
        Encoding verify = Bech32.verify(bech32);
        if (verify == null) {
            throw new IllegalArgumentException(String.format("bad bech32 %s", bech32));
        }
        String bech32Low = bech32.toLowerCase();
        String bech32Upp = bech32.toUpperCase();
        if (!bech32Low.equals(bech32) && !bech32Upp.equals(bech32)) {
            throw new IllegalArgumentException(String.format("mixed case bech32 %s", bech32));
        }
        int lastIndex = bech32Low.lastIndexOf("1");
        String hrp = bech32Low.substring(0, lastIndex);
        String rawData = bech32Low.substring(lastIndex + 1);
        byte[] dataBytes = Bech32.getBech32AlphabetDecodingValue(rawData.substring(0, rawData.length() - 6));
        if (dataBytes.length == 0) {
            throw new IllegalArgumentException("Empty data section");
        }
        Bech32Data bech32Data = new Bech32Data();
        bech32Data.setHrp(hrp);
        bech32Data.setDataBytes(dataBytes);
        bech32Data.setEncoding(verify);
        return bech32Data;
    }

    public static String encode(String hrp, byte[] bytes, Encoding encoding) {
        byte[] checksum = Bech32.createChecksum(hrp, bytes, encoding);
        byte[] data = Bytes.add(bytes, checksum);
        String value = Bytes.byteArrayToString(Bech32.getBech32AlphabetValue(data));
        return String.format("%s1%s", hrp, value);
    }

    public static String decodeSegwit(String bech32) {
        Bech32Data decoded = Bech32.decode(bech32);
        if (!decoded.getHrp().equals("bc") && !decoded.getHrp().equals("tb")) {
            throw new IllegalArgumentException(String.format("invalid HRP %s", decoded.getHrp()));
        }
        byte version = decoded.getDataBytes()[0];
        if (version < 0 || version > 16) {
            throw new IllegalArgumentException(String.format("invalid version %s", version));
        }
        if (version == 0 && decoded.getEncoding().equals((Object)Encoding.BECH32M)) {
            throw new IllegalArgumentException(String.format("invalid checksum (Bech32m instead of Bech32) %s", bech32));
        }
        if (version > 0 && decoded.getEncoding().equals((Object)Encoding.BECH32)) {
            throw new IllegalArgumentException(String.format("invalid checksum (Bech32 instead of Bech32m) %s", bech32));
        }
        byte[] program5 = Arrays.copyOfRange(decoded.getDataBytes(), 1, decoded.getDataBytes().length);
        byte[] program8 = Bech32.five2eight(program5);
        if (program8.length < 2 || program8.length > 40) {
            throw new IllegalArgumentException(String.format("invalid program length %s", program8.length));
        }
        byte[] scriptPubkey = new byte[2 + program8.length];
        if (version == 0) {
            if (program8.length != 20 && program8.length != 32) {
                throw new IllegalArgumentException(String.format("invalid program length %s for version 0", program8.length));
            }
            scriptPubkey[0] = version;
        } else {
            scriptPubkey[0] = (byte)(version + 80);
        }
        scriptPubkey[1] = (byte)program8.length;
        System.arraycopy(program8, 0, scriptPubkey, 2, program8.length);
        return Bytes.byteArrayToHexString(scriptPubkey);
    }

    public static String encodeSegwit(String hrp, String scriptPubkey) {
        byte[] scriptPubkeyBytes = Bytes.hexStringToByteArray(scriptPubkey);
        byte version = scriptPubkeyBytes[0];
        byte[] program8 = Arrays.copyOfRange(scriptPubkeyBytes, 2, scriptPubkeyBytes.length);
        byte[] program5 = Bech32.eight2five(program8);
        return Bech32.encode(hrp, Bytes.add(new byte[]{version}, program5), version == 0 ? Encoding.BECH32 : Encoding.BECH32M);
    }

    public static String decodeNostr(String bech32) {
        Bech32Data decoded = Bech32.decode(bech32);
        byte[] bytes8 = Bech32.five2eight(decoded.dataBytes);
        return Bytes.byteArrayToHexString(bytes8);
    }

    public static String decodeLnurl(String bech32) {
        Bech32Data decoded = Bech32.decode(bech32);
        byte[] bytes8 = Bech32.five2eight(decoded.dataBytes);
        return Bytes.byteArrayToString(bytes8);
    }

    public static String encodeNostr(String hrp, String hexString) {
        byte[] bytes8 = Bytes.hexStringToByteArray(hexString);
        byte[] bytes5 = Bech32.eight2five(bytes8);
        return Bech32.encode(hrp, bytes5, Encoding.BECH32);
    }

    public static String encodeLnurl(String hrp, String lnurl) {
        byte[] bytes8 = lnurl.getBytes();
        byte[] bytes5 = Bech32.eight2five(bytes8);
        return Bech32.encode(hrp, bytes5, Encoding.BECH32);
    }

    public static byte[] five2eight(byte[] five) {
        return Bech32.convertBits(five, 5, 8, false);
    }

    public static byte[] eight2five(byte[] eight) {
        return Bech32.convertBits(eight, 8, 5, true);
    }

    private static byte[] convertBits(byte[] bytes, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (byte bite : bytes) {
            int value = bite & 0xFF;
            if (value >>> fromBits != 0) {
                throw new IllegalArgumentException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new IllegalArgumentException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    public static class Bech32Data {
        private String hrp;
        private byte[] dataBytes;
        private Encoding encoding;

        public String getHrp() {
            return this.hrp;
        }

        public void setHrp(String hrp) {
            this.hrp = hrp;
        }

        public byte[] getDataBytes() {
            return this.dataBytes;
        }

        public void setDataBytes(byte[] dataBytes) {
            this.dataBytes = dataBytes;
        }

        public Encoding getEncoding() {
            return this.encoding;
        }

        public void setEncoding(Encoding encoding) {
            this.encoding = encoding;
        }
    }

    public static enum Encoding {
        BECH32,
        BECH32M;

    }
}

