/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.tx;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Helper;
import ch.bitagent.bitcoin.lib.helper.Properties;
import ch.bitagent.bitcoin.lib.network.Electrum;
import ch.bitagent.bitcoin.lib.network.Http;
import ch.bitagent.bitcoin.lib.tx.Tx;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

public class TxFetcher {
    private static final Logger log = Logger.getLogger(TxFetcher.class.getSimpleName());

    private TxFetcher() {
    }

    public static Tx fetch(String txId, Boolean testnet, Map<String, String> cache) {
        String txId64 = Helper.zfill(64, txId);
        String txRaw = null;
        if (cache == null || !cache.containsKey(txId64)) {
            long start = System.currentTimeMillis();
            try {
                Tx tx;
                txRaw = Properties.getBitcoinRpcAuth() != null && Properties.getBitcoinRpcTestnet().equals(testnet) ? Http.postGetRawTransaction(txId64) : (Boolean.TRUE.equals(testnet) ? new Electrum(true).getTransaction(txId64) : new Electrum().getTransaction(txId64));
                byte[] rawBytes = Bytes.hexStringToByteArray(txRaw);
                if (rawBytes[4] == 0) {
                    rawBytes = Bytes.add(Arrays.copyOfRange(rawBytes, 0, 4), Arrays.copyOfRange(rawBytes, 6, rawBytes.length));
                    tx = Tx.parse(rawBytes, testnet);
                    Hex locktime = Hex.parse(Bytes.changeOrder(Arrays.copyOfRange(rawBytes, rawBytes.length - 4, rawBytes.length)));
                    tx.setLocktime(locktime);
                } else {
                    tx = Tx.parse(rawBytes, testnet);
                }
                if (!tx.id().equals(txId64)) {
                    throw new IllegalStateException(String.format("not the same id: %s vs %s", tx.id(), txId64));
                }
                if (cache != null) {
                    cache.put(txId64, txRaw);
                    log.fine(String.format("tx %s to cache.", txId64));
                }
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                throw new IllegalStateException(e.getMessage());
            }
            log.fine(String.format("time %sms", System.currentTimeMillis() - start));
        } else {
            log.fine(String.format("tx %s from cache.", txId64));
            txRaw = cache.get(txId64);
        }
        byte[] txBytes = Bytes.hexStringToByteArray(txRaw);
        Tx tx = Tx.parse(txBytes, testnet);
        String computed = Boolean.TRUE.equals(tx.getSegwit()) ? tx.id() : Hex.parse(Bytes.changeOrder(Hash.hash256(txBytes))).toString();
        if (!computed.equals(txId64)) {
            throw new IllegalStateException(String.format("server lied: %s vs %s, segwit %s", computed, txId64, tx.getSegwit()));
        }
        log.fine(String.format("tx %s", tx));
        return tx;
    }
}

