/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.wallet;

import ch.bitagent.bitcoin.lib.ecc.PrivateKey;
import ch.bitagent.bitcoin.lib.ecc.S256Point;
import ch.bitagent.bitcoin.lib.network.Electrum;
import ch.bitagent.bitcoin.lib.tx.Tx;
import ch.bitagent.bitcoin.lib.tx.TxIn;
import ch.bitagent.bitcoin.lib.tx.Utxo;
import ch.bitagent.bitcoin.lib.wallet.Address;
import ch.bitagent.bitcoin.lib.wallet.AddressChangeIndex;
import ch.bitagent.bitcoin.lib.wallet.ExtendedKey;
import ch.bitagent.bitcoin.lib.wallet.Message;
import ch.bitagent.bitcoin.lib.wallet.MnemonicSentence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Wallet {
    private static final Logger log = Logger.getLogger(Wallet.class.getSimpleName());
    public static final int PURPOSE_NATIVE_SEGWIT = 84;
    public static final int COIN_TYPE_BITCOIN = 0;
    private final ExtendedKey extendedKey;
    private final int gapLimit;
    private final List<Address> addressList0 = new ArrayList<Address>();
    private final List<Address> addressList1 = new ArrayList<Address>();
    private final List<Utxo> utxoList = new ArrayList<Utxo>();

    public static String createMnemonic(int entropyStrength) {
        byte[] entropy = MnemonicSentence.generateEntropy(entropyStrength);
        return MnemonicSentence.entropyToMnemonic(entropy);
    }

    public Wallet(ExtendedKey extendedKey, int gapLimit) {
        if (Arrays.compare(extendedKey.getPrefix(), ExtendedKey.PREFIX_ZPRV.toBytes()) != 0 && Arrays.compare(extendedKey.getPrefix(), ExtendedKey.PREFIX_ZPUB.toBytes()) != 0) {
            throw new IllegalArgumentException("Prefix not supported");
        }
        if (gapLimit < 1) {
            throw new IllegalArgumentException("Minimal gap limit is 1");
        }
        this.extendedKey = extendedKey;
        this.gapLimit = gapLimit;
        this.addressList0.addAll(Wallet.deriveAddresses(extendedKey, 0, 0, gapLimit - 1));
        this.addressList1.addAll(Wallet.deriveAddresses(extendedKey, 1, 0, gapLimit - 1));
    }

    public static Wallet parse(ExtendedKey extendedKey, int gapLimit) {
        return new Wallet(extendedKey, gapLimit);
    }

    public static Wallet parse(String mnemonicSentence, String passphrase, int purpose, int coinType, int account, int gapLimit) {
        if (purpose != 84) {
            throw new IllegalArgumentException("Purpose not supported!");
        }
        if (coinType != 0) {
            throw new IllegalArgumentException("Coin type not supported!");
        }
        if (account < 0) {
            throw new IllegalArgumentException("Account not supported!");
        }
        byte[] seed = MnemonicSentence.mnemonicToSeed(mnemonicSentence, passphrase);
        String zprv = MnemonicSentence.seedToExtendedKey(seed, ExtendedKey.PREFIX_ZPRV);
        ExtendedKey m = ExtendedKey.parse(zprv);
        ExtendedKey m84h0h0h = m.derive(purpose, true, false).derive(coinType, true, false).derive(account, true, false);
        return new Wallet(m84h0h0h, gapLimit);
    }

    public static List<Address> deriveAddresses(ExtendedKey extendedKey, int change, int indexFrom, int indexTo) {
        log.fine(String.format("derive %s/%s/%s", change, indexFrom, indexTo));
        ExtendedKey extendedKeyChange = extendedKey.derive(change);
        ArrayList<Address> addressList = new ArrayList<Address>();
        for (int i = indexFrom; i <= indexTo; ++i) {
            ExtendedKey extendedKeyi = extendedKeyChange.derive(i);
            S256Point publicKeyi = ExtendedKey.isKeyPrivate(extendedKeyi.getPrefix()) ? PrivateKey.parse(extendedKeyi.getKey()).getPoint() : S256Point.parse(extendedKeyi.getKey());
            Address addressi = Address.parse(publicKeyi.addressBech32P2wpkh(false));
            addressi.setChangeIndex(new AddressChangeIndex(change, i));
            addressList.add(addressi);
        }
        return addressList;
    }

    public void history(int change) {
        Electrum electrum = new Electrum();
        int gap = 0;
        List<Address> addressList = this.getAddressList0();
        if (change != 0) {
            if (change == 1) {
                addressList = this.getAddressList1();
            } else {
                throw new IllegalArgumentException("Invalid change");
            }
        }
        for (int i = 0; i < addressList.size(); ++i) {
            JSONObject balance;
            Address address = addressList.get(i);
            String scripthash = address.electrumScripthash();
            JSONArray history = electrum.getHistory(scripthash);
            if (history.isEmpty()) {
                ++gap;
            }
            if (i == addressList.size() - 1 && gap < this.gapLimit) {
                int indexFrom = i + 1;
                int indexTo = i + this.gapLimit - gap;
                List<Address> derviedAddresses = Wallet.deriveAddresses(this.extendedKey, change, indexFrom, indexTo);
                addressList.addAll(derviedAddresses);
            }
            if (history.isEmpty()) continue;
            address.setHistoryCount(history.length());
            if (history.isEmpty() || (balance = electrum.getBalance(scripthash)) == null) continue;
            address.setUnconfirmed(balance.getLong("unconfirmed"));
            address.setConfirmed(balance.getLong("confirmed"));
            if (address.getUnconfirmed() <= 0L && address.getConfirmed() <= 0L) continue;
            JSONArray unspent = electrum.listUnspent(address.electrumScripthash());
            for (int j = 0; j < unspent.length(); ++j) {
                this.utxoList.add(new Utxo(unspent.getJSONObject(j), address.getChangeIndex()));
            }
        }
    }

    public Address nextReceiveAddress() {
        for (Address address : this.addressList0) {
            if (address.getHistoryCount() != 0) continue;
            return address;
        }
        return null;
    }

    public Address nextChangeAddress() {
        for (Address address : this.addressList1) {
            if (address.getHistoryCount() != 0) continue;
            return address;
        }
        return null;
    }

    public PrivateKey getPrivateKeyForChangeIndex(AddressChangeIndex changeIndex) {
        if (ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix())) {
            return PrivateKey.parse(this.extendedKey.derive(changeIndex.getChange()).derive(changeIndex.getIndex()).getKey());
        }
        throw new IllegalArgumentException("Private key is not available");
    }

    public String signMessage(String address, String message) {
        if (ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix())) {
            for (int i = 0; i < this.addressList0.size(); ++i) {
                if (!this.addressList0.get(i).getAddressString().equals(address)) continue;
                ExtendedKey extendedKey0i = this.extendedKey.derive(0).derive(i);
                PrivateKey privateKey0i = PrivateKey.parse(extendedKey0i.getKey());
                return Message.sign(privateKey0i, message, "bech32", true);
            }
            throw new IllegalArgumentException("Address not found");
        }
        throw new IllegalArgumentException("Sign message with a public key not possible");
    }

    public boolean verifyMessage(String address, String signature, String message) {
        for (int i = 0; i < this.addressList0.size(); ++i) {
            if (!this.addressList0.get(i).getAddressString().equals(address)) continue;
            ExtendedKey extendedKey0i = this.extendedKey.derive(0).derive(i);
            S256Point publicKey0i = ExtendedKey.isKeyPrivate(this.extendedKey.getPrefix()) ? PrivateKey.parse(extendedKey0i.getKey()).getPoint() : S256Point.parse(extendedKey0i.getKey());
            return Message.verify(publicKey0i, signature, message, true);
        }
        throw new IllegalArgumentException("Address not found");
    }

    public ExtendedKey getExtendedKey() {
        return this.extendedKey;
    }

    public List<Address> getAddressList0() {
        return this.addressList0;
    }

    public List<Address> getAddressList1() {
        return this.addressList1;
    }

    public List<Utxo> getUtxoList() {
        return this.utxoList;
    }

    public long getUtxoAmount() {
        long utxoAmount = 0L;
        for (Utxo utxo : this.utxoList) {
            if (utxo.getHeight() <= 0) continue;
            utxoAmount += utxo.getValue();
        }
        return utxoAmount;
    }

    public List<TxIn> getTxInList() {
        ArrayList<TxIn> txInList = new ArrayList<TxIn>();
        for (Utxo utxo : this.utxoList) {
            if (utxo.getHeight() <= 0) continue;
            txInList.add(new TxIn(utxo));
        }
        return txInList;
    }

    public void txSignInput(Tx tx, List<TxIn> txInList, Map<String, String> cache) {
        for (int i = 0; i < txInList.size(); ++i) {
            boolean verified = tx.signInput(i, this.getPrivateKeyForChangeIndex(txInList.get(i).getUtxo().getChangeIndex()), cache);
            if (verified) continue;
            throw new IllegalStateException();
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.addAll(this.addressList0);
        addressList.addAll(this.addressList1);
        for (Address address : addressList) {
            string.append("\n");
            string.append(address);
        }
        for (Utxo utxo : this.utxoList) {
            string.append("\n");
            string.append(utxo);
        }
        return string.toString();
    }
}

