/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.block;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import ch.bitagent.bitcoin.lib.helper.Merkle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Block {
    public static final Int GENESIS_BLOCK = Hex.parse("0100000000000000000000000000000000000000000000000000000000000000000000003ba3edfd7a7b12b27ac72c3e67768f617fc81bc3888a51323a9fb8aa4b1e5e4a29ab5f49ffff001d1dac2b7c");
    public static final Int TESTNET_GENESIS_BLOCK = Hex.parse("0100000000000000000000000000000000000000000000000000000000000000000000003ba3edfd7a7b12b27ac72c3e67768f617fc81bc3888a51323a9fb8aa4b1e5e4adae5494dffff001d1aa4ae18");
    public static final Int LOWEST_BITS = Hex.parse("ffff001d");
    private final Int version;
    private final byte[] prevBlock;
    private final byte[] merkleRoot;
    private final Int timestamp;
    private final byte[] bits;
    private final byte[] nonce;
    private List<byte[]> txHashes;

    public Block(Int version, byte[] prevBlock, byte[] merkleRoot, Int timestamp, byte[] bits, byte[] nonce) {
        this.version = version;
        this.prevBlock = prevBlock;
        this.merkleRoot = merkleRoot;
        this.timestamp = timestamp;
        this.bits = bits;
        this.nonce = nonce;
    }

    public static Block parse(ByteArrayInputStream stream) {
        Hex version = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        byte[] prevBlock = Bytes.changeOrder(Bytes.read(stream, 32));
        byte[] merkleRoot = Bytes.changeOrder(Bytes.read(stream, 32));
        Hex timestamp = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        byte[] bits = Bytes.read(stream, 4);
        byte[] nonce = Bytes.read(stream, 4);
        return new Block(version, prevBlock, merkleRoot, timestamp, bits, nonce);
    }

    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.getVersion().toBytesLittleEndian(4));
        result.writeBytes(Bytes.changeOrder(this.prevBlock));
        result.writeBytes(Bytes.changeOrder(this.merkleRoot));
        result.writeBytes(Bytes.changeOrder(this.timestamp.toBytes()));
        result.writeBytes(this.bits);
        result.writeBytes(this.nonce);
        return result.toByteArray();
    }

    public byte[] hash() {
        byte[] stream = this.serialize();
        byte[] h256 = Hash.hash256(stream);
        return Bytes.changeOrder(h256);
    }

    public boolean isBip9() {
        return this.version.intValue() >> 29 == 1;
    }

    public boolean isBip91() {
        return (this.version.intValue() >> 4 & 1) == 1;
    }

    public boolean isBip141() {
        return (this.version.intValue() >> 1 & 1) == 1;
    }

    public Int target() {
        return Bytes.bitsToTarget(this.bits);
    }

    public Int difficulty() {
        Int lowest = Hex.parse("ffff").mul(Int.parse(256).pow(Hex.parse("1d").sub(Int.parse(3))));
        return lowest.div(this.target());
    }

    public Int proof() {
        byte[] h256 = Hash.hash256(this.serialize());
        return Hex.parse(Bytes.changeOrder(h256));
    }

    public boolean checkPow() {
        return this.proof().lt(this.target());
    }

    public boolean validateMerkleRoot() {
        List<byte[]> hashes = this.txHashes.stream().map(Bytes::changeOrder).collect(Collectors.toList());
        byte[] root = Bytes.changeOrder(Merkle.merkleRoot(hashes));
        return Arrays.equals(this.merkleRoot, root);
    }

    public Int getVersion() {
        return this.version;
    }

    public Int getTimestamp() {
        return this.timestamp;
    }

    public byte[] getPrevBlock() {
        return this.prevBlock;
    }

    public byte[] getMerkleRoot() {
        return this.merkleRoot;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setTxHashes(List<byte[]> txHashes) {
        this.txHashes = txHashes;
    }
}

