/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.helper;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.helper.Hash;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class Base58 {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";

    private Base58() {
    }

    public static String encode(byte[] s) {
        int count = 0;
        for (byte c : s) {
            if (c != 0) break;
            ++count;
        }
        Int num = Hex.parse(s);
        Int zero = Int.parse(0);
        String prefix = "1".repeat(count);
        StringBuilder result = new StringBuilder();
        while (num.gt(zero)) {
            BigInteger[] numMod = num.bigInt().divideAndRemainder(BigInteger.valueOf(58L));
            num = Int.parse(numMod[0]);
            result.insert(0, BASE58_ALPHABET.charAt(numMod[1].intValue()));
        }
        return prefix + String.valueOf(result);
    }

    public static String encodeChecksum(byte[] b) {
        return Base58.encode(Bytes.add(b, Arrays.copyOfRange(Hash.hash256(b), 0, 4)));
    }

    public static byte[] decodeAddress(String address) {
        Int num = Base58.decode(address);
        byte[] combined = num.toBytes(25);
        Base58.compareChecksum(combined);
        return Arrays.copyOfRange(combined, 1, combined.length - 4);
    }

    public static byte[] decodeExtendedKey(String extendedKey) {
        Int num = Base58.decode(extendedKey);
        byte[] combined = num.toBytes(82);
        Base58.compareChecksum(combined);
        return Arrays.copyOfRange(combined, 0, combined.length - 4);
    }

    public static byte[] decodeWif(String wif, boolean compressed) {
        Int num = Base58.decode(wif);
        byte[] combined = num.toBytes(compressed ? 38 : 37);
        Base58.compareChecksum(combined);
        return Arrays.copyOfRange(combined, 0, combined.length - 4);
    }

    private static Int decode(String s) {
        Int fiveEight = Int.parse(58);
        Int num = Int.parse(0);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            num = num.mul(fiveEight);
            num = num.add(Int.parse(BASE58_ALPHABET.indexOf(c)));
        }
        return num;
    }

    private static void compareChecksum(byte[] combined) {
        byte[] checksum = Arrays.copyOfRange(combined, combined.length - 4, combined.length);
        byte[] hashInput = Arrays.copyOfRange(combined, 0, combined.length - 4);
        byte[] hash = Hash.hash256(hashInput);
        byte[] hashChecksum = Arrays.copyOfRange(hash, 0, 4);
        if (Arrays.compare(hashChecksum, checksum) != 0) {
            throw new IllegalStateException(String.format("bad checksum %h %h", checksum, hashChecksum));
        }
    }

    public static String h160toP2pkhAddress(byte[] h160, Boolean testnet) {
        byte[] prefix = Boolean.TRUE.equals(testnet = Objects.requireNonNullElse(testnet, false)) ? new byte[]{111} : new byte[]{0};
        return Base58.encodeChecksum(Bytes.add(prefix, h160));
    }

    public static String h160toP2shAddress(byte[] h160, Boolean testnet) {
        byte[] prefix = Boolean.TRUE.equals(testnet = Objects.requireNonNullElse(testnet, false)) ? new byte[]{-60} : new byte[]{5};
        return Base58.encodeChecksum(Bytes.add(prefix, h160));
    }
}

