/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.network;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.network.Message;
import java.io.ByteArrayInputStream;

public class SendCompactMessage
implements Message {
    public static final String COMMAND = "sendcmpct";
    private final Int announce;
    private final Int version;

    @Override
    public byte[] getCommand() {
        return COMMAND.getBytes();
    }

    public SendCompactMessage(Int announce, Int version) {
        this.announce = announce;
        this.version = version;
    }

    public static SendCompactMessage parse(ByteArrayInputStream stream) {
        Hex announce = Hex.parse(Bytes.read(stream, 1));
        Hex version = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 8)));
        return new SendCompactMessage(announce, version);
    }

    @Override
    public byte[] serialize() {
        return new byte[0];
    }

    public String toString() {
        return "SendCompactMessage{announce=" + String.valueOf(this.announce) + ", version=" + String.valueOf(this.version) + "}";
    }
}

