/*
 * Decompiled with CFR 0.152.
 */
package ch.bitagent.bitcoin.lib.tx;

import ch.bitagent.bitcoin.lib.ecc.Hex;
import ch.bitagent.bitcoin.lib.ecc.Int;
import ch.bitagent.bitcoin.lib.helper.Bytes;
import ch.bitagent.bitcoin.lib.script.Script;
import ch.bitagent.bitcoin.lib.tx.Tx;
import ch.bitagent.bitcoin.lib.tx.TxFetcher;
import ch.bitagent.bitcoin.lib.tx.Utxo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class TxIn {
    private static final Logger log = Logger.getLogger(TxIn.class.getSimpleName());
    public static final Int SEQUENCE_DEF = Hex.parse("ffffffff");
    public static final Int SEQUENCE_RBF = Hex.parse("fffffffd");
    private final Utxo utxo;
    private final Int prevTx;
    private final Int prevIndex;
    private Script scriptSig;
    private final Int sequence;
    private Script witness;

    public TxIn(Int prevTx, Int prevIndex, Script scriptSig, Int sequence) {
        this.utxo = null;
        this.prevTx = prevTx;
        this.prevIndex = prevIndex;
        this.scriptSig = Objects.requireNonNullElse(scriptSig, new Script(null));
        this.sequence = Objects.requireNonNullElse(sequence, SEQUENCE_DEF);
        log.fine(this.toString());
    }

    public TxIn(Utxo utxo) {
        this.utxo = utxo;
        this.prevTx = Hex.parse(utxo.getTxHash());
        this.prevIndex = Int.parse(utxo.getTxPos());
        this.scriptSig = new Script(null);
        this.sequence = SEQUENCE_RBF;
        log.fine(this.toString());
    }

    public static TxIn parse(ByteArrayInputStream stream) {
        Hex prevTx = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 32)));
        Hex prevIndex = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        Script scriptSig = Script.parse(stream);
        Hex sequence = Hex.parse(Bytes.changeOrder(Bytes.read(stream, 4)));
        return new TxIn(prevTx, prevIndex, scriptSig, sequence);
    }

    public byte[] serialize() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.writeBytes(this.prevTx.toBytesLittleEndian(32));
        result.writeBytes(this.prevIndex.toBytesLittleEndian(4));
        result.writeBytes(this.scriptSig.serialize());
        result.writeBytes(this.sequence.toBytesLittleEndian(4));
        return result.toByteArray();
    }

    private Tx fetchPrevTx(Boolean testnet, Map<String, String> cache) {
        return TxFetcher.fetch(this.prevTx.toHex().toString(), testnet, cache);
    }

    public Int value(Boolean testnet, Map<String, String> cache) {
        Tx tx = this.fetchPrevTx(testnet, cache);
        return tx.getTxOuts().get(this.prevIndex.intValue()).getAmount();
    }

    public Script scriptPubkey(Boolean testnet, Map<String, String> cache) {
        Tx tx = this.fetchPrevTx(testnet, cache);
        return tx.getTxOuts().get(this.prevIndex.intValue()).getScriptPubkey();
    }

    public String toString() {
        return String.format("txin %s:%s:%s:%s:%s", this.prevTx, this.prevIndex.intValue(), this.scriptSig, this.sequence, this.witness != null ? this.witness : "");
    }

    public Int getPrevTx() {
        return this.prevTx;
    }

    public Int getPrevIndex() {
        return this.prevIndex;
    }

    public Script getScriptSig() {
        return this.scriptSig;
    }

    public void setScriptSig(Script scriptSig) {
        this.scriptSig = scriptSig;
    }

    public Int getSequence() {
        return this.sequence;
    }

    public Script getWitness() {
        return this.witness;
    }

    public void setWitness(Script witness) {
        this.witness = witness;
    }

    public Utxo getUtxo() {
        return this.utxo;
    }
}

