/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.db;

import ch.brickwork.bsetl.db.Db;
import ch.brickwork.bsetl.db.exception.MoreThanOneColumnPresentException;
import ch.brickwork.bsetl.db.exception.MoreThanOneRowPresentException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;

public class Result {
    private ResultSet resultSet;
    private List<Map<String, Object>> listOfRowMaps = null;
    private Db obtainedFrom;

    public Result(ResultSet resultSet, Db obtainedFrom) {
        this.resultSet = resultSet;
        this.obtainedFrom = obtainedFrom;
    }

    public List<Map<String, Object>> getRowsAsMap() throws SQLException {
        if (this.listOfRowMaps == null) {
            this.listOfRowMaps = new ArrayList<Map<String, Object>>();
            while (this.resultSet.next()) {
                TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (int col = 1; col <= this.resultSet.getMetaData().getColumnCount(); ++col) {
                    map.put(this.resultSet.getMetaData().getColumnName(col), this.resultSet.getObject(col));
                }
                this.listOfRowMaps.add(map);
            }
        }
        return this.listOfRowMaps;
    }

    public Object getSingleRowPropertyValue(String propertyName) throws MoreThanOneRowPresentException, SQLException {
        List<Map<String, Object>> maps = this.getRowsAsMap();
        if (maps.size() != 1) {
            throw new MoreThanOneRowPresentException("You should only use this method for results with one row as a result, this one has " + maps.size());
        }
        return maps.get(0).get(propertyName);
    }

    public Set<Object> singleColumnValues() throws MoreThanOneColumnPresentException, SQLException {
        List<Map<String, Object>> rows = this.getRowsAsMap();
        if (CollectionUtils.isEmpty(rows)) {
            return SetUtils.EMPTY_SORTED_SET;
        }
        if (rows.get(0).keySet().size() != 1) {
            throw new MoreThanOneColumnPresentException();
        }
        return rows.stream().map(row -> row.get(row.keySet().iterator().next())).collect(Collectors.toSet());
    }

    public Set<Object> getColumnValues(String columnName) throws SQLException {
        return this.getRowsAsMap().stream().map(row -> row.get(columnName)).collect(Collectors.toSet());
    }

    public Set<Object> getColumnNonNullValues(String columnName) throws SQLException {
        return this.getRowsAsMap().stream().map(row -> row.get(columnName)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public String getColumnValuesAsSQLSet(String columnName) throws SQLException {
        return this.obtainedFrom.toSQLSet(this.getColumnValues(columnName));
    }

    public String singleColumnValuesAsSQLSet() throws SQLException, MoreThanOneColumnPresentException {
        return this.obtainedFrom.toSQLSet(this.singleColumnValues());
    }

    public int countRows() throws SQLException {
        return this.getRowsAsMap().size();
    }

    public Object vLookUp(String searchProperty, Object valueToMatchWith, String targetProperty) throws SQLException {
        for (Map<String, Object> row : this.getRowsAsMap()) {
            if (!Objects.equals(row.get(searchProperty), valueToMatchWith)) continue;
            return row.get(targetProperty);
        }
        return null;
    }

    public int size() throws SQLException {
        if (this.listOfRowMaps == null) {
            this.getRowsAsMap();
        }
        return CollectionUtils.size(this.listOfRowMaps);
    }
}

