/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.RandomSanitizer;
import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import ch.brickwork.bsetl.sanitize.exception.TypeNotSanitizableException;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CompositeSanitizer
implements ValueSanitizer {
    private static final Object NULL_TOKEN_VALUE = "-";
    private static final ValueSanitizer DEFAULT_VALUE_SANITIZER = new RandomSanitizer();
    private final String divider;
    private final ValueSanitizer[] sanitizers;

    public CompositeSanitizer(String divider, ValueSanitizer ... sanitizers) {
        this.divider = divider;
        this.sanitizers = sanitizers;
    }

    @Override
    public Object sanitize(Object originalValue, String rowId, String propertyName) {
        if (originalValue == null) {
            return null;
        }
        if (originalValue instanceof String) {
            String[] tokens = StringUtils.split((String)originalValue.toString(), (String)this.divider);
            StringJoiner stringJoiner = new StringJoiner(this.divider);
            for (int i = 0; i < tokens.length; ++i) {
                ValueSanitizer sanitizer = i < this.sanitizers.length ? this.sanitizers[i] : DEFAULT_VALUE_SANITIZER;
                stringJoiner.add(Objects.toString(ObjectUtils.firstNonNull((Object[])new Object[]{sanitizer.sanitize(tokens[i], rowId, propertyName), NULL_TOKEN_VALUE})));
            }
            return stringJoiner.toString();
        }
        throw new TypeNotSanitizableException("You can only use Strings in composite sanitizers");
    }
}

