/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.RandomElementFromSetSanitizer;
import ch.brickwork.bsetl.sanitize.RandomSanitizer;
import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import ch.brickwork.bsetl.sanitize.constant.InternetDomains;
import ch.brickwork.bsetl.sanitize.constant.de.HumanNames;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PersonSanitizer
implements ValueSanitizer {
    private final String[] firstNames;
    private final String[] lastNames;
    private final String[] domains;
    private final String[] nameColumns;
    private final String[] emailColumns;
    private final String[] firstNameColumns;
    private final String[] lastNameColumns;
    private Map<String, PersonCacheItem> contextCache = new HashMap<String, PersonCacheItem>();

    public PersonSanitizer(String[] nameColumns, String[] emailColumns, String[] firstNameColumns, String[] lastNameColumns) {
        this(HumanNames.TOP_SWISS_FIRSTNAMES, HumanNames.TOP_GERMAN_LASTNAMES, InternetDomains.RANDOM_MAIL_DOMAINS, nameColumns, emailColumns, firstNameColumns, lastNameColumns);
    }

    public PersonSanitizer(String[] firstNames, String[] lastNames, String[] mailDomains, String[] nameColumns, String[] emailColumns, String[] firstNameColumns, String[] lastNameColumns) {
        this.firstNames = firstNames;
        this.lastNames = lastNames;
        this.domains = mailDomains;
        this.nameColumns = nameColumns;
        this.emailColumns = emailColumns;
        this.firstNameColumns = firstNameColumns;
        this.lastNameColumns = lastNameColumns;
    }

    @Override
    public Object sanitize(Object originalValue, String rowId, String propertyName) {
        if (originalValue == null) {
            return null;
        }
        if (rowId == null) {
            return RandomSanitizer.random(originalValue.getClass());
        }
        if (!this.contextCache.containsKey(rowId)) {
            this.contextCache.put(rowId, new PersonCacheItem(ArrayUtils.isEmpty((Object[])this.firstNames) ? null : RandomElementFromSetSanitizer.pickAny(this.firstNames).toString(), ArrayUtils.isEmpty((Object[])this.lastNames) ? null : RandomElementFromSetSanitizer.pickAny(this.lastNames).toString(), ArrayUtils.isEmpty((Object[])this.domains) ? null : RandomElementFromSetSanitizer.pickAny(this.domains).toString(), 0));
        }
        PersonCacheItem person = this.contextCache.get(rowId);
        if (ArrayUtils.contains((Object[])this.nameColumns, (Object)propertyName)) {
            return new StringJoiner(" ").add(StringUtils.capitalize((String)person.firstName.toLowerCase())).add(StringUtils.capitalize((String)person.lastName.toLowerCase())).toString();
        }
        if (ArrayUtils.contains((Object[])this.emailColumns, (Object)propertyName)) {
            return new StringJoiner("@").add(new StringJoiner(".").add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.lowerCase((String)person.firstName), ""})).add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.lowerCase((String)person.lastName), ""})).toString()).add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{person.domain, ""})).toString();
        }
        if (ArrayUtils.contains((Object[])this.firstNameColumns, (Object)propertyName)) {
            return StringUtils.capitalize((String)person.firstName.toLowerCase());
        }
        if (ArrayUtils.contains((Object[])this.lastNameColumns, (Object)propertyName)) {
            return StringUtils.capitalize((String)person.lastName.toLowerCase());
        }
        return RandomSanitizer.random(originalValue.getClass());
    }

    private class PersonCacheItem {
        String firstName;
        String lastName;
        String domain;
        int usageCount;

        @ConstructorProperties(value={"firstName", "lastName", "domain", "usageCount"})
        public PersonCacheItem(String firstName, String lastName, String domain, int usageCount) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.domain = domain;
            this.usageCount = usageCount;
        }
    }
}

