/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.db;

import ch.brickwork.bsetl.db.Preprocessor;
import ch.brickwork.bsetl.db.Result;
import ch.brickwork.bsetl.db.TableStructure;
import ch.brickwork.bsetl.db.exception.MapValueException;
import ch.brickwork.bsetl.db.exception.OperationNotAllowedException;
import ch.brickwork.bsetl.db.exception.TableNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class Db {
    private static String DEFAULT_DRIVER_CLASS_NAME = "org.h2.Driver";
    private static String DEFAULT_URL = "jdbc:h2:file:~/default.h2";
    private static String DEFAULT_SCHEMA_NAME = "";
    private static String DEFAULT_USER_NAME = "sa";
    private static String DEFAULT_PASSWORD = "";
    private Connection con;
    private FileWriter executeQueryDumpFileWriter;
    private String url;
    private String driver;
    private String user;
    private String password;
    private long statementCount = 0L;
    private int maxStatementsPerTransaction;
    private ArrayList<Preprocessor> preprocessors = new ArrayList();
    private Map<String, Long> insertCounts = new HashMap<String, Long>();
    private IdentityHashMap<String, TableStructure> tables = new IdentityHashMap();

    public Db() throws SQLException, ClassNotFoundException, IOException {
        this(DEFAULT_URL, DEFAULT_DRIVER_CLASS_NAME, DEFAULT_USER_NAME, DEFAULT_PASSWORD, null, 0);
    }

    public Db(String url, String driver, String user, String password, File executeQueryDumpFile, int maxStatementsPerTransaction) throws ClassNotFoundException, SQLException, IOException {
        this.user = user;
        this.password = password;
        this.driver = driver;
        this.url = url;
        if (url != null) {
            this.driver = driver;
            Class.forName(this.driver);
            this.getConnection();
        } else {
            this.con = null;
        }
        this.executeQueryDumpFileWriter = executeQueryDumpFile != null ? new FileWriter(executeQueryDumpFile) : null;
        this.maxStatementsPerTransaction = maxStatementsPerTransaction;
        if (maxStatementsPerTransaction > 0) {
            if (this.con != null) {
                this.con.setAutoCommit(false);
            }
            this.appendToFile(this.beginTransactionStatement() + "\n");
        }
    }

    private void getConnection() throws SQLException {
        if (this.con != null && this.con.isValid(1)) {
            this.con.close();
        }
        this.con = DriverManager.getConnection(this.url, this.user, this.password);
    }

    public void appendToFile(String text) throws IOException {
        this.executeQueryDumpFileWriter.append(text);
    }

    public void addPreprocessor(Preprocessor preprocessor) {
        this.preprocessors.add(preprocessor);
    }

    public Result query(String query) throws SQLException {
        ResultSet rs;
        System.out.println(query);
        if (this.con != null) {
            Statement statement = this.con.createStatement();
            rs = statement.executeQuery(query);
            this.commitIfNecessary();
        } else {
            rs = null;
        }
        ++this.statementCount;
        return new Result(rs, this);
    }

    public boolean execute(String query) throws SQLException, IOException {
        System.out.println(query);
        this.dumpQuery(query);
        return this.executeQuery(query);
    }

    protected boolean executeQuery(String query) throws SQLException {
        boolean result;
        if (this.con != null) {
            Statement statement = this.con.createStatement();
            result = statement.execute(query);
            this.commitIfNecessary();
        } else {
            result = false;
        }
        ++this.statementCount;
        return result;
    }

    protected void dumpQuery(String query) throws IOException {
        if (this.executeQueryDumpFileWriter != null) {
            this.appendToFile("\n");
            if (this.maxStatementsPerTransaction > 0 && this.isCommitNecessary()) {
                this.appendToFile(this.commitStatement() + "\n" + this.beginTransactionStatement() + "\n");
            }
            this.appendToFile(query);
            if (!query.trim().endsWith(";")) {
                this.appendToFile(";");
            }
        }
    }

    public void closeConnection() throws SQLException, IOException {
        if (this.con != null) {
            this.con.close();
        }
        if (this.executeQueryDumpFileWriter != null) {
            if (this.maxStatementsPerTransaction > 0) {
                this.appendToFile("\n" + this.commitStatement());
            }
            this.executeQueryDumpFileWriter.flush();
        }
    }

    public void switchExecuteQueryFile(File newFile) throws IOException {
        if (this.executeQueryDumpFileWriter != null) {
            this.executeQueryDumpFileWriter.flush();
        }
        this.executeQueryDumpFileWriter = new FileWriter(newFile);
    }

    public void insert(Result rowsToInsert, String targetTableName) throws SQLException, IOException, OperationNotAllowedException {
        this.insert(rowsToInsert.getRowsAsMap(), targetTableName);
    }

    public void insert(List<Map<String, Object>> rowsToInsert, String targetTableName) throws SQLException, IOException, OperationNotAllowedException {
        System.out.println("Inserting " + rowsToInsert.size() + " into " + targetTableName);
        if (rowsToInsert.size() == 0) {
            System.out.println("...table is empty");
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(rowsToInsert.get(0).keySet());
        for (Map<String, Object> unprocessedRow : rowsToInsert) {
            Map<String, ?> row = this.truncate(this.preprocess(targetTableName, unprocessedRow), targetTableName);
            String sql = "INSERT INTO " + this.quoteIdentifierIfNecessary(targetTableName) + "(" + keys.stream().map(key -> this.quoteIdentifierIfNecessary((String)key)).collect(Collectors.joining(",")) + ") VALUES (" + row.keySet().stream().map(key -> this.wrap(row.get(key))).collect(Collectors.joining(",")) + ")";
            this.execute(sql);
            this.insertCounts.compute(targetTableName, (k, v) -> v == null ? 1L : v + 1L);
        }
        System.out.println("...insert done");
    }

    public void copyTableFrom(String tableName, Db sourceDb) throws SQLException, IOException, OperationNotAllowedException {
        TableStructure tableStructure = sourceDb.getTableStructure(tableName);
        if (tableStructure == null) {
            throw new TableNotFoundException(tableName);
        }
        this.createOrReplaceTable(tableStructure);
        this.insert(sourceDb.query("SELECT * FROM " + tableName), tableName);
    }

    protected String beginTransactionStatement() {
        return "BEGIN TRANSACTION";
    }

    protected String commitStatement() {
        return "COMMIT;";
    }

    private Map<String, ?> truncate(Map<String, Object> row, String tableName) throws SQLException, OperationNotAllowedException {
        TableStructure tableStructure = this.getTableStructure(tableName);
        if (tableStructure == null) {
            System.out.println("Could not find table structure for " + tableName + " in \n" + this.tables.toString());
        }
        Iterator<String> propertyNameIterator = row.keySet().iterator();
        while (propertyNameIterator.hasNext()) {
            String currentValue;
            String propertyName = Objects.toString(propertyNameIterator.next());
            Integer length = tableStructure.getColumns().get(propertyName).getLength();
            if (!this.isCharacterLike(tableStructure.getColumns().get(propertyName).getDataType()) || length == null || (currentValue = this.encode(Objects.toString(this.mapValue(Objects.toString(row.get(propertyName)))))) == null || currentValue.toString().length() <= length) continue;
            row.put(propertyName, currentValue.toString().substring(0, length - 1));
        }
        return row;
    }

    public String toSQLSet(Set setOfValues) {
        return "(" + setOfValues.stream().map(val -> this.wrap(val)).collect(Collectors.joining(",")) + ")";
    }

    public String wherePropertyIn(String propertyName, Set set) {
        return set.isEmpty() ? "" : " WHERE " + propertyName + " IN " + this.toSQLSet(set);
    }

    public static String quote(Object unquoted) {
        return "'" + unquoted + "'";
    }

    public TableStructure getTableStructure(String tableName) throws SQLException, OperationNotAllowedException {
        if (this.con == null) {
            return this.tables.get(tableName);
        }
        TableStructure tableStructure = new TableStructure(tableName);
        Statement sProperties = this.con.createStatement();
        ResultSet rsCols = sProperties.executeQuery(Db.getSourceColumnNamesStatement(tableName));
        while (rsCols.next()) {
            tableStructure.addColumn(rsCols.getString("column_name"), this.mapDataType(rsCols.getString("data_type")), rsCols.getInt("character_maximum_length"));
        }
        if (tableStructure.getColumns().size() == 0) {
            return null;
        }
        return tableStructure;
    }

    public boolean createOrReplaceTable(TableStructure tableStructure) throws SQLException, IOException, OperationNotAllowedException {
        if (this.con != null) {
            this.dropIfExists(tableStructure.getTableName());
        }
        String sql = "CREATE TABLE " + this.quoteIdentifierIfNecessary(tableStructure.getTableName()) + "(" + tableStructure.getColumns().keySet().stream().map(key -> this.tableStructureEntry(tableStructure.getColumns().get(key))).collect(Collectors.joining(",")) + ");";
        this.tables.put(tableStructure.getTableName(), tableStructure);
        return this.execute(sql);
    }

    public void cleanDuplicates(String tableName, String uniqueKeyPropertyName) throws SQLException, IOException {
        this.execute("DELETE FROM " + tableName + " a USING (      SELECT MIN(ctid) as ctid, " + uniqueKeyPropertyName + "        FROM " + tableName + "        GROUP BY " + uniqueKeyPropertyName + " HAVING COUNT(*) > 1      ) b      WHERE a." + uniqueKeyPropertyName + " = b." + uniqueKeyPropertyName + "      AND a.ctid <> b.ctid;");
    }

    protected void dropIfExists(String tableName) throws SQLException, IOException, OperationNotAllowedException {
        if (this.getTableStructure(tableName) != null) {
            this.execute("DROP TABLE IF EXISTS " + this.quoteIdentifierIfNecessary(tableName) + " ;");
        }
    }

    protected boolean isCharacterLike(String dataType) {
        return StringUtils.contains((CharSequence)dataType.toLowerCase(), (CharSequence)"char");
    }

    public String wrap(Object value) {
        return this.encode(this.quoteIfNecessary(this.mapValue(value)));
    }

    protected String encode(String value) {
        return value;
    }

    protected String quoteIfNecessary(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return Db.quote(o.toString());
        }
        return o.toString();
    }

    protected Object mapValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return StringEscapeUtils.escapeJava((String)((String)o)).replaceAll("'", this.escapedQuoteLiteral());
        }
        if (o instanceof Number || o instanceof Boolean) {
            return o;
        }
        if (o instanceof Timestamp || o instanceof Date) {
            return o.toString();
        }
        if (o instanceof byte[]) {
            return Hex.encodeHexString((byte[])((byte[])o));
        }
        throw new MapValueException("Could not map value of class " + o.getClass());
    }

    protected String escapedQuoteLiteral() {
        return "''";
    }

    protected String quoteIdentifierIfNecessary(String unquotedTableName) {
        return unquotedTableName;
    }

    protected String mapDataType(String originalDataType) {
        return originalDataType;
    }

    protected String tableStructureEntry(TableStructure.PropertyStructure propertyStructure) {
        String lengthOrEmpty = propertyStructure.getDataType().equalsIgnoreCase("varchar") && propertyStructure.getLength() != null ? "(" + propertyStructure.getLength() + ")" : "";
        return this.quoteIdentifierIfNecessary(propertyStructure.getColumnName()) + " " + this.mapDataType(propertyStructure.getDataType()) + lengthOrEmpty;
    }

    private Map<String, Object> preprocess(String tableName, Map<String, Object> row) {
        for (Preprocessor preprocessor : this.preprocessors) {
            row = preprocessor.preprocessRow(tableName, row);
        }
        return row;
    }

    private static String getSourceColumnNamesStatement(String name) {
        return "select * from information_schema.columns where lower(table_name)='" + name.toLowerCase() + "'";
    }

    private void commitIfNecessary() throws SQLException {
        if (this.con != null && this.isCommitNecessary()) {
            this.con.commit();
        }
    }

    private boolean isCommitNecessary() {
        return this.maxStatementsPerTransaction > 0 && this.statementCount % (long)this.maxStatementsPerTransaction == 0L;
    }

    public Connection getCon() {
        return this.con;
    }

    public FileWriter getExecuteQueryDumpFileWriter() {
        return this.executeQueryDumpFileWriter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public long getStatementCount() {
        return this.statementCount;
    }

    public int getMaxStatementsPerTransaction() {
        return this.maxStatementsPerTransaction;
    }

    public ArrayList<Preprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    public IdentityHashMap<String, TableStructure> getTables() {
        return this.tables;
    }

    public Map<String, Long> getInsertCounts() {
        return this.insertCounts;
    }
}

