/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.db;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.TreeMap;

public class TableStructure {
    private String tableName;
    private Map<String, PropertyStructure> columns = new TreeMap<String, PropertyStructure>(String.CASE_INSENSITIVE_ORDER);

    public TableStructure(String tableName) {
        this.tableName = tableName;
    }

    public void addColumn(String columnName, String dataType, Integer length) {
        this.columns.put(columnName, new PropertyStructure(columnName, dataType, length != null && length > 0 ? length : null));
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, PropertyStructure> getColumns() {
        return this.columns;
    }

    public class PropertyStructure {
        private String columnName;
        private String dataType;
        private Integer length;

        public String getColumnName() {
            return this.columnName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public Integer getLength() {
            return this.length;
        }

        @ConstructorProperties(value={"columnName", "dataType", "length"})
        public PropertyStructure(String columnName, String dataType, Integer length) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.length = length;
        }
    }
}

