/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.CorrelatedColumnsSanitizer;
import ch.brickwork.bsetl.sanitize.constant.InternetDomains;
import ch.brickwork.bsetl.sanitize.constant.de.HumanNames;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PersonSanitizer
extends CorrelatedColumnsSanitizer {
    public PersonSanitizer(String[] nameColumns, String[] emailColumns, String[] firstNameColumns, String[] lastNameColumns, boolean putFirstnameFirst) {
        this(HumanNames.TOP_SWISS_FIRSTNAMES, HumanNames.TOP_GERMAN_LASTNAMES, InternetDomains.RANDOM_MAIL_DOMAINS, nameColumns, emailColumns, firstNameColumns, lastNameColumns, putFirstnameFirst);
    }

    public PersonSanitizer(String[] firstNames, String[] lastNames, String[] mailDomains, String[] nameColumns, String[] emailColumns, String[] firstNameColumns, String[] lastNameColumns, boolean putFirstnameFirst) {
        super(new String[][]{firstNames, lastNames, mailDomains}, null);
        for (String firstNameColumn : firstNameColumns) {
            super.addColumn(firstNameColumn, components -> this.capitalizeLowerCase(Objects.toString(components[0])));
        }
        for (String lastNameColumn : lastNameColumns) {
            super.addColumn(lastNameColumn, components -> this.capitalizeLowerCase(Objects.toString(components[1])));
        }
        for (String nameColumn : nameColumns) {
            super.addColumn(nameColumn, components -> new StringJoiner(" ").add(this.capitalizeLowerCase(Objects.toString(components[putFirstnameFirst ? 0 : 1]))).add(this.capitalizeLowerCase(Objects.toString(components[putFirstnameFirst ? 1 : 0]))).toString());
        }
        for (String emailColumn : emailColumns) {
            super.addColumn(emailColumn, components -> new StringJoiner("@").add(new StringJoiner(".").add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.lowerCase((String)Objects.toString(components[putFirstnameFirst ? 0 : 1])), ""})).add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.lowerCase((String)Objects.toString(components[putFirstnameFirst ? 1 : 0])), ""})).toString()).add((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{Objects.toString(components[2]), ""})).toString());
            this.replaceInvalidEmailCharacters(emailColumn);
        }
    }

    private String capitalizeLowerCase(String s) {
        return StringUtils.capitalize((String)StringUtils.lowerCase((String)s));
    }

    private void replaceInvalidEmailCharacters(String s) {
        s.replace("\u00e4", "ae").replace("\u00e0", "a").replace("\u00e1", "a").replace("\u00e2", "a").replace("\u00e7", "c").replace("\u00e8", "e").replace("\u00e9", "e").replace("\u00eb", "e").replace("\u00ea", "e").replace("\u00ef", "i").replace("\u00ee", "i").replace("\u00f1", "n").replace("\u00f6", "oe").replace("\u00f4", "o").replace("\u00fc", "ue").replace("\u00fb", "u").replace("\u00f9", "u").replace("\u00df", "ss").replace("\u00ff", "y");
    }
}

