/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.RandomSanitizer;
import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class RandomDictionnarySanitizer
implements ValueSanitizer {
    private final Stack<Object> vocabulary;
    private Map<Object, Object> dictionnary = new HashMap<Object, Object>();

    public RandomDictionnarySanitizer(Stack<Object> vocabulary) {
        this.vocabulary = vocabulary;
    }

    @Override
    public Object sanitize(Object originalValue, String rowId, String propertyName) {
        if (originalValue == null) {
            return null;
        }
        if (!this.dictionnary.containsKey(originalValue)) {
            this.dictionnary.put(originalValue, this.vocabulary.empty() ? RandomSanitizer.random(originalValue.getClass()) : this.vocabulary.pop());
        }
        return this.dictionnary.get(originalValue);
    }
}

