/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import ch.brickwork.bsetl.sanitize.exception.TypeNotSanitizableException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;

public class RandomSanitizer
implements ValueSanitizer {
    private static final long DEFAULT_NUMERIC_RANGE_START_INCLUSIVE = 0L;
    private static final long DEFAULT_NUMERIC_RANGE_END_INCLUSIVE = 10000000L;
    private final long numericRangeStartInclusive;
    private final long numericRangeEndInclusive;
    private final String hint;
    private final Integer maxLength;

    public RandomSanitizer() {
        this.numericRangeStartInclusive = 0L;
        this.numericRangeEndInclusive = 10000000L;
        this.hint = null;
        this.maxLength = null;
    }

    public RandomSanitizer(String hint) {
        this.numericRangeStartInclusive = 0L;
        this.numericRangeEndInclusive = 10000000L;
        this.hint = hint;
        this.maxLength = null;
    }

    public RandomSanitizer(long integerRangeStartInclusive, long numericRangeEndInclusive) {
        this.numericRangeStartInclusive = integerRangeStartInclusive;
        this.numericRangeEndInclusive = numericRangeEndInclusive;
        this.hint = null;
        this.maxLength = null;
    }

    public RandomSanitizer(String hint, int maxLength) {
        this.numericRangeStartInclusive = 0L;
        this.numericRangeEndInclusive = 10000000L;
        this.hint = hint;
        this.maxLength = maxLength;
    }

    @Override
    public Object sanitize(Object originalValue, String rowId, String propertyName) {
        if (originalValue == null) {
            return null;
        }
        return RandomSanitizer.random(originalValue.getClass(), this.numericRangeStartInclusive, this.numericRangeEndInclusive, this.hint, this.maxLength);
    }

    public static Object random(Class<?> clazz) {
        return RandomSanitizer.random(clazz, 0L, 10000000L, null, null);
    }

    public static Object random(Class<?> clazz, long numericRangeStartInclusive, long numericRangeEndInclusive, String hint, Integer maxLength) {
        if (clazz == String.class) {
            String text = (hint == null ? "" : hint + "/") + DigestUtils.md5Hex((String)String.valueOf(Math.random() * 1.0E7));
            if (maxLength == null) {
                return text;
            }
            return text.substring(0, Math.min(maxLength, text.length()));
        }
        if (clazz == Long.class) {
            return RandomUtils.nextLong((long)numericRangeStartInclusive, (long)numericRangeEndInclusive);
        }
        if (clazz == Integer.class) {
            return RandomUtils.nextInt((int)((int)numericRangeStartInclusive), (int)((int)numericRangeEndInclusive));
        }
        if (clazz == Float.class) {
            return Float.valueOf(RandomUtils.nextFloat((float)numericRangeStartInclusive, (float)numericRangeEndInclusive));
        }
        if (clazz == Double.class) {
            return RandomUtils.nextDouble((double)numericRangeStartInclusive, (double)numericRangeEndInclusive);
        }
        if (clazz == Date.class) {
            return Date.from(LocalDateTime.now().plusDays(RandomUtils.nextInt((int)0, (int)100)).toInstant(ZoneOffset.UTC));
        }
        if (clazz == Timestamp.class) {
            return Timestamp.valueOf(LocalDateTime.now().plusDays(RandomUtils.nextInt((int)0, (int)100)));
        }
        System.out.println("Not sanitizable exception will be thrown; parameters are: numericRange " + numericRangeStartInclusive + " - " + numericRangeEndInclusive + ", hint: " + hint + ", maxLength: " + maxLength);
        throw new TypeNotSanitizableException(clazz.toString());
    }
}

