/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.db;

import ch.brickwork.bsetl.db.BinaryString;
import ch.brickwork.bsetl.db.Db;
import ch.brickwork.bsetl.db.PropertyStructure;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;

public class MSSQLDb
extends Db {
    private final boolean addGoAfterTransactionCommit;

    public MSSQLDb() throws SQLException, ClassNotFoundException, IOException {
        this.addGoAfterTransactionCommit = true;
    }

    public MSSQLDb(String url, String driver, String user, String password, File executeQueryFile, int maxStatementsPerTransaction, boolean addGoAfterTransactionCommit) throws ClassNotFoundException, SQLException, IOException {
        super(url, driver, user, password, executeQueryFile, maxStatementsPerTransaction);
        this.addGoAfterTransactionCommit = addGoAfterTransactionCommit;
    }

    @Override
    protected String mapDataType(String originalDataType) {
        if (originalDataType.equalsIgnoreCase("TIMESTAMP")) {
            return "datetime";
        }
        if (originalDataType.equalsIgnoreCase("boolean")) {
            return "short";
        }
        if (originalDataType.toLowerCase().contains("char")) {
            return "VARCHAR";
        }
        return super.mapDataType(originalDataType);
    }

    @Override
    protected Object mapValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return ((String)o).replaceAll("'", this.escapedQuoteLiteral());
        }
        if (o instanceof Timestamp) {
            String result = o.toString().replaceAll("\\..+", "");
            return result.trim().equals("") ? null : result;
        }
        if (o instanceof byte[] && ((byte[])o).length == 8) {
            return null;
        }
        if (o instanceof byte[]) {
            return new BinaryString("0x" + super.mapValue(o));
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return super.mapValue(o);
    }

    @Override
    protected String tableStructureEntry(PropertyStructure propertyStructure) {
        String result = super.tableStructureEntry(propertyStructure);
        if (result.toLowerCase().endsWith("varchar")) {
            return result + "(MAX)";
        }
        return result;
    }

    @Override
    protected String commitStatement() {
        return "COMMIT;" + (this.addGoAfterTransactionCommit ? "\nGO\n" : "");
    }
}

