/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.db;

import ch.brickwork.bsetl.db.Db;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Hex;

public class PostgresDB
extends Db {
    public PostgresDB() throws SQLException, ClassNotFoundException, IOException {
    }

    public PostgresDB(String url, String driver, String user, String password, File executeQueryFile, int maxStatementsPerTransaction) throws ClassNotFoundException, SQLException, IOException {
        super(url, driver, user, password, executeQueryFile, maxStatementsPerTransaction);
    }

    @Override
    protected String encode(String s) {
        return s;
    }

    @Override
    protected String mapDataType(String originalDataType) {
        if (originalDataType.equals("boolean")) {
            return "boolean";
        }
        if (originalDataType.equals("varbinary") || originalDataType.contains("char")) {
            return "varchar";
        }
        if (originalDataType.equals("datetime")) {
            return "timestamp";
        }
        if (originalDataType.equals("uniqueidentifier")) {
            return "varchar";
        }
        if (originalDataType.equals("bit")) {
            return "boolean";
        }
        if (originalDataType.equals("image")) {
            return "bytea";
        }
        return super.mapDataType(originalDataType);
    }

    @Override
    protected Object mapValue(Object o) {
        if (o instanceof String) {
            return ((String)o).replaceAll("'", this.escapedQuoteLiteral());
        }
        if (o instanceof byte[]) {
            return "\\x" + Hex.encodeHexString((byte[])((byte[])o));
        }
        return super.mapValue(o);
    }

    @Override
    protected String beginTransactionStatement() {
        return "BEGIN;";
    }

    @Override
    protected String quoteIdentifierIfNecessary(String unquotedTableName) {
        if ("to".equalsIgnoreCase(unquotedTableName)) {
            return "\"" + unquotedTableName + "\"";
        }
        return unquotedTableName;
    }
}

