/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.RandomElementFromSetSanitizer;
import ch.brickwork.bsetl.sanitize.RandomSanitizer;
import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CorrelatedColumnsSanitizer
implements ValueSanitizer {
    private static final int MAX_ATTEMPTS_TO_FIND_NEW_VALUE = 10;
    private final Object[][] components;
    private final Map<String, Function<Object[], Object>> valueBuilders = new HashMap<String, Function<Object[], Object>>();
    private final Function<Object[], Object> defaultValueBuilder;
    private Map<String, Object[]> contextCache = new HashMap<String, Object[]>();

    public CorrelatedColumnsSanitizer(String[][] components, Function<Object[], Object> defaultValueBuilder) {
        this.components = components;
        this.defaultValueBuilder = defaultValueBuilder == null ? comps -> Stream.of(comps).map(comp -> String.valueOf(comp)).collect(Collectors.joining(" ")) : defaultValueBuilder;
    }

    public void addColumn(String columnName, Function<Object[], Object> valueBuilder) {
        this.valueBuilders.put(columnName, valueBuilder);
    }

    @Override
    public Object sanitize(Object originalValue, String rowId, String propertyName) {
        if (originalValue == null) {
            return null;
        }
        if (rowId != null) {
            if (!this.contextCache.containsKey(rowId)) {
                Object[] permutationOfComponentElements = null;
                for (int attempt = 0; attempt < 10 && this.contains(this.contextCache, permutationOfComponentElements = Stream.of(this.components).map(RandomElementFromSetSanitizer::pickAny).toArray()); ++attempt) {
                    if (attempt != 9) continue;
                    permutationOfComponentElements[permutationOfComponentElements.length - 1] = String.valueOf(permutationOfComponentElements[permutationOfComponentElements.length - 1]).concat(" ").concat(String.valueOf(RandomSanitizer.random(String.class)));
                }
                this.contextCache.put(rowId, permutationOfComponentElements);
            }
            Object[] componentValues = this.contextCache.get(rowId);
            if (this.valueBuilders.containsKey(propertyName)) {
                return this.valueBuilders.get(propertyName).apply(componentValues);
            }
            return this.defaultValueBuilder.apply(componentValues);
        }
        return RandomSanitizer.random(originalValue.getClass());
    }

    private boolean contains(Map<?, Object[]> set, Object[] candidate) {
        for (Object[] element : set.values()) {
            if (!Arrays.equals(element, candidate)) continue;
            return true;
        }
        return false;
    }
}

