/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.db.Preprocessor;
import ch.brickwork.bsetl.sanitize.SanitizerConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DbSanitizer
implements Preprocessor {
    private SanitizerConfiguration sanitizerConfiguration;
    private Set<String> touchedColumns = new HashSet<String>();
    private Function<Map<String, Object>, String> getIdFromMap = map -> null;

    public DbSanitizer(SanitizerConfiguration sanitizerConfiguration) {
        this.sanitizerConfiguration = sanitizerConfiguration;
    }

    public DbSanitizer(SanitizerConfiguration sanitizerConfiguration, Function<Map<String, Object>, String> getIdFromMap) {
        this.sanitizerConfiguration = sanitizerConfiguration;
        this.getIdFromMap = getIdFromMap;
    }

    @Override
    public Map<String, Object> preprocessRow(String tableName, Map<String, Object> inputRow) {
        for (String propertyName : inputRow.keySet()) {
            if (!this.sanitizerConfiguration.shouldSanitize(tableName, propertyName)) continue;
            inputRow.put(propertyName, this.sanitizerConfiguration.getSanitizer(tableName, propertyName).sanitize(inputRow.get(propertyName), this.getIdFromMap.apply(inputRow), propertyName));
            this.touchedColumns.add(SanitizerConfiguration.key(tableName, propertyName));
        }
        return inputRow;
    }

    public Set<String> getUntouchedColumns() {
        return this.sanitizerConfiguration.getSanitizedColumns().stream().filter(col -> !this.touchedColumns.contains(col)).collect(Collectors.toSet());
    }
}

