/*
 * Decompiled with CFR 0.152.
 */
package ch.brickwork.bsetl.sanitize;

import ch.brickwork.bsetl.sanitize.ValueSanitizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SanitizerConfiguration {
    private Map<String, ValueSanitizer> columnsToBeSanitized = new HashMap<String, ValueSanitizer>();

    public void addColumnToBeSanitized(String tableName, String columnName, ValueSanitizer sanitizer) {
        this.columnsToBeSanitized.put(SanitizerConfiguration.key(tableName, columnName), sanitizer);
    }

    public boolean shouldSanitize(String tableName, String propertyName) {
        return this.columnsToBeSanitized.containsKey(SanitizerConfiguration.key(tableName, propertyName));
    }

    public ValueSanitizer getSanitizer(String tableName, String propertyName) {
        return this.columnsToBeSanitized.get(SanitizerConfiguration.key(tableName, propertyName));
    }

    public static String key(String tableName, String columnName) {
        return tableName + "." + columnName;
    }

    public Set<String> getSanitizedColumns() {
        return this.columnsToBeSanitized.keySet();
    }
}

