/*
 * Decompiled with CFR 0.152.
 */
package ch.brix.gql.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import lombok.NonNull;

public class Scalar {
    @NonNull
    private final String value;

    public String toString() {
        return this.value;
    }

    public Scalar from(Object object) {
        return new Scalar(object.toString());
    }

    public boolean getBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public int getInt() {
        return Integer.parseInt(this.value);
    }

    public byte getByte() {
        return Byte.parseByte(this.value);
    }

    public long getLong() {
        return Long.parseLong(this.value);
    }

    public short getShort() {
        return Short.parseShort(this.value);
    }

    public char getChar() {
        return this.value.charAt(0);
    }

    public BigInteger getBigInteger() {
        return new BigInteger(this.value);
    }

    public double getDouble() {
        return Double.parseDouble(this.value);
    }

    public float getFloat() {
        return Float.parseFloat(this.value);
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    public Date getDateFromUnixSeconds() {
        return new Date(Long.parseLong(this.value) * 1000L);
    }

    public Date getDateFromUnixMilis() {
        return new Date(Long.parseLong(this.value));
    }

    public Date getDate(SimpleDateFormat sdf) throws ParseException {
        return sdf.parse(this.value);
    }

    public TemporalAccessor getDate(DateTimeFormatter formatter) {
        return formatter.parse(this.value);
    }

    public Locale getLocale() {
        return Locale.forLanguageTag(this.value);
    }

    public Duration getDuration() {
        return Duration.parse(this.value);
    }

    public Scalar(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }
}

