/*
 * Decompiled with CFR 0.152.
 */
package ch.brix.gql.client;

import ch.brix.gql.client.Call;
import ch.brix.gql.client.InnerType;
import ch.brix.gql.client.Scalar;
import ch.brix.gql.client.TypeRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

public class Deserializer {
    public static <T> T deserializeResult(JsonElement json, Call<T> call, TypeRegistry typeRegistry) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (!json.isJsonObject()) {
            throw new RuntimeException("JsonObject expected");
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("errors")) {
            JsonElement errors = obj.get("errors");
            if (errors.isJsonArray() && !errors.getAsJsonArray().isEmpty()) {
                throw new RuntimeException(errors.getAsJsonArray().asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).filter(o -> o.has("message")).map(o -> o.get("message")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).filter(Objects::nonNull).filter(s -> !s.isBlank()).collect(Collectors.joining("\n\n")));
            }
            throw new RuntimeException("Received errors in unknown format");
        }
        if (obj.has("error")) {
            throw new RuntimeException(obj.get("error").getAsString());
        }
        if (obj.has("data")) {
            if (!obj.get("data").isJsonObject()) {
                throw new RuntimeException("data object expected");
            }
            if (!(obj = obj.get("data").getAsJsonObject()).has(call.getName())) {
                return null;
            }
            return (T)Deserializer.deserialize(obj.get(call.getName()), call, typeRegistry);
        }
        return null;
    }

    private static Object deserialize(JsonElement json, Call call, TypeRegistry typeRegistry) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (json.isJsonNull()) {
            return null;
        }
        Class<?> type = typeRegistry.getType(call.getInnerReturnType());
        if (type != null && Scalar.class.isAssignableFrom(type)) {
            return type.getDeclaredMethod("of", Object.class).invoke(null, json.isJsonPrimitive() ? json.getAsString() : json.toString());
        }
        if (json.isJsonArray()) {
            return Deserializer.deserializeList(json.getAsJsonArray(), call, typeRegistry);
        }
        if (json.isJsonPrimitive()) {
            if (type == null) {
                throw new RuntimeException("Unknown type " + call.getInnerReturnType());
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, json.getAsString());
            }
            throw new RuntimeException("Json primitive is not enum and not scalar");
        }
        JsonObject obj = json.getAsJsonObject();
        type = typeRegistry.getType(obj.get("__typename").getAsString());
        if (type == null) {
            type = typeRegistry.getType(call.getInnerReturnType());
        }
        return Deserializer.getObject(type, typeRegistry, obj);
    }

    private static Object deserialize(JsonElement json, Class<?> type, TypeRegistry typeRegistry) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (json.isJsonNull()) {
            return null;
        }
        if (Scalar.class.isAssignableFrom(type)) {
            return type.getDeclaredMethod("of", Object.class).invoke(null, json.isJsonPrimitive() ? json.getAsString() : json.toString());
        }
        if (json.isJsonArray()) {
            ArrayList<Object> ret = new ArrayList<Object>(json.getAsJsonArray().size());
            for (JsonElement element : json.getAsJsonArray()) {
                ret.add(Deserializer.deserialize(element, type, typeRegistry));
            }
            return ret;
        }
        if (json.isJsonPrimitive()) {
            if (type.isEnum()) {
                return Enum.valueOf(type, json.getAsString());
            }
            throw new RuntimeException("Json primitive is not enum or scalar");
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("__typename")) {
            type = typeRegistry.getType(obj.get("__typename").getAsString());
        }
        return Deserializer.getObject(type, typeRegistry, obj);
    }

    private static Object getObject(Class<?> type, TypeRegistry typeRegistry, JsonObject obj) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (Scalar.class.isAssignableFrom(type)) {
            return type.getDeclaredMethod("of", Object.class).invoke(null, obj.toString());
        }
        Object ret = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : type.getDeclaredFields()) {
            SerializedName serializedName = field.getDeclaredAnnotation(SerializedName.class);
            if (serializedName == null || !obj.has(serializedName.value()) || obj.get(serializedName.value()).isJsonNull()) continue;
            JsonElement value = obj.get(serializedName.value());
            String setterName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method setter = type.getDeclaredMethod(setterName, field.getType());
            InnerType innerType = field.getDeclaredAnnotation(InnerType.class);
            setter.invoke(ret, Deserializer.deserialize(value, innerType == null ? field.getType() : innerType.value(), typeRegistry));
        }
        return ret;
    }

    private static Object deserializeList(JsonArray arr, Call call, TypeRegistry typeRegistry) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement element : arr) {
            list.add(Deserializer.deserialize(element, call, typeRegistry));
        }
        return list;
    }
}

