/*
 * Decompiled with CFR 0.152.
 */
package ch.brix.gql.client;

import ch.brix.gql.client.CallBuilder;
import ch.brix.gql.client.Deserializer;
import ch.brix.gql.client.Query;
import ch.brix.gql.client.Serializer;
import ch.brix.gql.client.TypeRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private final String endpoint;
    private final OkHttpClient client;
    private final TypeRegistry typeRegistry;
    private final Gson gson = new Gson();

    public Client(String endpoint, TypeRegistry typeRegistry) {
        this(endpoint, new OkHttpClient.Builder().build(), typeRegistry);
    }

    public <T> T execute(CallBuilder<T> callBuilder) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        JsonElement jsonResult;
        String serializedCall = Serializer.serializeRootCall(callBuilder._call);
        log.debug(serializedCall);
        Call call = this.client.newCall(new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)this.gson.toJson((Object)new Query(serializedCall)))).build());
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                if (response.body() != null) {
                    String rspns = response.body().string();
                    log.debug(rspns);
                    Deserializer.deserializeResult(JsonParser.parseString((String)rspns), callBuilder._call, this.typeRegistry);
                }
                throw new RemoteException("Request failed with code = " + response.code() + " and message: " + response.message());
            }
            if (response.body() == null) {
                T t = null;
                return t;
            }
            jsonResult = JsonParser.parseReader((Reader)response.body().charStream());
        }
        return Deserializer.deserializeResult(jsonResult, callBuilder._call, this.typeRegistry);
    }

    @Generated
    public Client(String endpoint, OkHttpClient client, TypeRegistry typeRegistry) {
        this.endpoint = endpoint;
        this.client = client;
        this.typeRegistry = typeRegistry;
    }
}

