/*
 * Decompiled with CFR 0.152.
 */
package ch.brix.gql.client;

import ch.brix.gql.client.Call;
import ch.brix.gql.client.InputObject;
import ch.brix.gql.client.On;
import ch.brix.gql.client.Scalar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Serializer {
    public static String serializeRootCall(Call<?> call) {
        return (call.isMutation() ? "mutation" : "") + "{" + Serializer.serialize(call) + "}";
    }

    private static String serialize(Call<?> call) {
        return call.getName() + Serializer.serialize(call.getArgs()) + (String)(call.getOns().isEmpty() ? "" : "{" + Serializer.serialize(call.getOns(), call.getInnerReturnType()) + "}");
    }

    private static String serialize(Set<On> ons, String innerReturnType) {
        return ons.stream().map(on -> (String)(on.getType().equals(innerReturnType) ? "" : "...on " + on.getType() + "{") + Serializer.serialize(on) + (on.getType().equals(innerReturnType) ? "" : "}")).collect(Collectors.joining(" "));
    }

    private static String serialize(On on) {
        return "__typename " + String.join((CharSequence)" ", on.getFields()) + (String)(on.getCalls().isEmpty() ? "" : " " + Serializer.serialize(on.getCalls()));
    }

    private static String serialize(Set<Call<?>> calls) {
        return calls.stream().map(Serializer::serialize).collect(Collectors.joining(" "));
    }

    private static String serialize(Map<String, Object> args) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        return "(" + args.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + Serializer.serializeObject(entry.getValue())).collect(Collectors.joining(",")) + ")";
    }

    private static String serializeObject(Object value) {
        if (value instanceof List) {
            return "[" + ((List)value).stream().map(Serializer::serializeObject).collect(Collectors.joining(",")) + "]";
        }
        if (value instanceof Scalar) {
            String v = ((Scalar)value).getValue().replace("\\", "\\\\").replace("\"", "\\\"");
            switch (value.getClass().getSimpleName()) {
                case "IntScalar": 
                case "BooleanScalar": 
                case "FloatScalar": {
                    return v;
                }
            }
            return "\"" + v.replace("\r", "").replace("\n", "\\n").replace("\t", "\\t") + "\"";
        }
        if (value instanceof Enum) {
            return value.toString();
        }
        if (value == null) {
            return "null";
        }
        return "{" + ((InputObject)value).values.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + Serializer.serializeObject(entry.getValue())).collect(Collectors.joining(",")) + "}";
    }
}

