/*
 * Decompiled with CFR 0.152.
 */
package ch.brix.gql.client;

import ch.brix.gql.client.CallBuilder;
import ch.brix.gql.client.Client;
import ch.brix.gql.client.TypeRegistry;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Queue;
import okhttp3.OkHttpClient;

public class ThrottledClient
extends Client {
    private final Queue<Long> queue = new LinkedList<Long>();
    private final long requests;
    private final long perSeconds;

    public ThrottledClient(String endpoint, TypeRegistry typeRegistry, long requests, long perSeconds) {
        this(endpoint, new OkHttpClient.Builder().build(), typeRegistry, requests, perSeconds);
    }

    public ThrottledClient(String endpoint, OkHttpClient client, TypeRegistry typeRegistry, long requests, long perSeconds) {
        super(endpoint, client, typeRegistry);
        this.requests = requests;
        this.perSeconds = perSeconds;
    }

    @Override
    public synchronized <T> T execute(CallBuilder<T> callBuilder) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        long t = System.currentTimeMillis();
        this.queue.offer(t + this.perSeconds * 1000L);
        while (!this.queue.isEmpty() && this.queue.peek() < t) {
            this.queue.poll();
        }
        if ((long)this.queue.size() >= this.requests) {
            try {
                long sleep = this.queue.poll() - System.currentTimeMillis();
                if (sleep > 0L) {
                    Thread.sleep(sleep);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return super.execute(callBuilder);
    }
}

