package ch.brix.gql.client.frontify.enums;

/**
 * Language code based on the ISO 639-1 standard, represented as two-letter codes such as en (English), de (German), and es (Spanish).
 */
public enum LanguageCode {
  /**
   * Abkhazian
   */
  @com.google.gson.annotations.SerializedName("AB") 
  AB,
  /**
   * Afar
   */
  @com.google.gson.annotations.SerializedName("AA") 
  AA,
  /**
   * Afrikaans
   */
  @com.google.gson.annotations.SerializedName("AF") 
  AF,
  /**
   * Akan
   */
  @com.google.gson.annotations.SerializedName("AK") 
  AK,
  /**
   * Albanian
   */
  @com.google.gson.annotations.SerializedName("SQ") 
  SQ,
  /**
   * Amharic
   */
  @com.google.gson.annotations.SerializedName("AM") 
  AM,
  /**
   * Arabic
   */
  @com.google.gson.annotations.SerializedName("AR") 
  AR,
  /**
   * Aragonese
   */
  @com.google.gson.annotations.SerializedName("AN") 
  AN,
  /**
   * Armenian
   */
  @com.google.gson.annotations.SerializedName("HY") 
  HY,
  /**
   * Assamese
   */
  @com.google.gson.annotations.SerializedName("AS") 
  AS,
  /**
   * Avaric
   */
  @com.google.gson.annotations.SerializedName("AV") 
  AV,
  /**
   * Avestan
   */
  @com.google.gson.annotations.SerializedName("AE") 
  AE,
  /**
   * Aymara
   */
  @com.google.gson.annotations.SerializedName("AY") 
  AY,
  /**
   * Azerbaijani
   */
  @com.google.gson.annotations.SerializedName("AZ") 
  AZ,
  /**
   * Bambara
   */
  @com.google.gson.annotations.SerializedName("BM") 
  BM,
  /**
   * Bashkir
   */
  @com.google.gson.annotations.SerializedName("BA") 
  BA,
  /**
   * Basque
   */
  @com.google.gson.annotations.SerializedName("EU") 
  EU,
  /**
   * Belarusian
   */
  @com.google.gson.annotations.SerializedName("BE") 
  BE,
  /**
   * Bengali
   */
  @com.google.gson.annotations.SerializedName("BN") 
  BN,
  /**
   * Bihari languages
   */
  @com.google.gson.annotations.SerializedName("BH") 
  BH,
  /**
   * Bislama
   */
  @com.google.gson.annotations.SerializedName("BI") 
  BI,
  /**
   * Bosnian
   */
  @com.google.gson.annotations.SerializedName("BS") 
  BS,
  /**
   * Breton
   */
  @com.google.gson.annotations.SerializedName("BR") 
  BR,
  /**
   * Bulgarian
   */
  @com.google.gson.annotations.SerializedName("BG") 
  BG,
  /**
   * Burmese
   */
  @com.google.gson.annotations.SerializedName("MY") 
  MY,
  /**
   * Catalan, Valencian
   */
  @com.google.gson.annotations.SerializedName("CA") 
  CA,
  /**
   * Central Khmer
   */
  @com.google.gson.annotations.SerializedName("KM") 
  KM,
  /**
   * Chamorro
   */
  @com.google.gson.annotations.SerializedName("CH") 
  CH,
  /**
   * Chechen
   */
  @com.google.gson.annotations.SerializedName("CE") 
  CE,
  /**
   * Chichewa, Chewa, Nyanja
   */
  @com.google.gson.annotations.SerializedName("NY") 
  NY,
  /**
   * Chinese
   */
  @com.google.gson.annotations.SerializedName("ZH") 
  ZH,
  /**
   * Church Slavonic, Old Bulgarian, Old Church Slavonic
   */
  @com.google.gson.annotations.SerializedName("CU") 
  CU,
  /**
   * Chuvash
   */
  @com.google.gson.annotations.SerializedName("CV") 
  CV,
  /**
   * Cornish
   */
  @com.google.gson.annotations.SerializedName("KW") 
  KW,
  /**
   * Corsican
   */
  @com.google.gson.annotations.SerializedName("CO") 
  CO,
  /**
   * Cree
   */
  @com.google.gson.annotations.SerializedName("CR") 
  CR,
  /**
   * Croatian
   */
  @com.google.gson.annotations.SerializedName("HR") 
  HR,
  /**
   * Czech
   */
  @com.google.gson.annotations.SerializedName("CS") 
  CS,
  /**
   * Danish
   */
  @com.google.gson.annotations.SerializedName("DA") 
  DA,
  /**
   * Divehi, Dhivehi, Maldivian
   */
  @com.google.gson.annotations.SerializedName("DV") 
  DV,
  /**
   * Dutch, Flemish
   */
  @com.google.gson.annotations.SerializedName("NL") 
  NL,
  /**
   * Dzongkha
   */
  @com.google.gson.annotations.SerializedName("DZ") 
  DZ,
  /**
   * English
   */
  @com.google.gson.annotations.SerializedName("EN") 
  EN,
  /**
   * Esperanto
   */
  @com.google.gson.annotations.SerializedName("EO") 
  EO,
  /**
   * Estonian
   */
  @com.google.gson.annotations.SerializedName("ET") 
  ET,
  /**
   * Ewe
   */
  @com.google.gson.annotations.SerializedName("EE") 
  EE,
  /**
   * Faroese
   */
  @com.google.gson.annotations.SerializedName("FO") 
  FO,
  /**
   * Fijian
   */
  @com.google.gson.annotations.SerializedName("FJ") 
  FJ,
  /**
   * Finnish
   */
  @com.google.gson.annotations.SerializedName("FI") 
  FI,
  /**
   * French
   */
  @com.google.gson.annotations.SerializedName("FR") 
  FR,
  /**
   * Fulah
   */
  @com.google.gson.annotations.SerializedName("FF") 
  FF,
  /**
   * Gaelic, Scottish Gaelic
   */
  @com.google.gson.annotations.SerializedName("GD") 
  GD,
  /**
   * Galician
   */
  @com.google.gson.annotations.SerializedName("GL") 
  GL,
  /**
   * Ganda
   */
  @com.google.gson.annotations.SerializedName("LG") 
  LG,
  /**
   * Georgian
   */
  @com.google.gson.annotations.SerializedName("KA") 
  KA,
  /**
   * German
   */
  @com.google.gson.annotations.SerializedName("DE") 
  DE,
  /**
   * Gikuyu, Kikuyu
   */
  @com.google.gson.annotations.SerializedName("KI") 
  KI,
  /**
   * Greek (Modern)
   */
  @com.google.gson.annotations.SerializedName("EL") 
  EL,
  /**
   * Greenlandic, Kalaallisut
   */
  @com.google.gson.annotations.SerializedName("KL") 
  KL,
  /**
   * Guarani
   */
  @com.google.gson.annotations.SerializedName("GN") 
  GN,
  /**
   * Gujarati
   */
  @com.google.gson.annotations.SerializedName("GU") 
  GU,
  /**
   * Haitian, Haitian Creole
   */
  @com.google.gson.annotations.SerializedName("HT") 
  HT,
  /**
   * Hausa
   */
  @com.google.gson.annotations.SerializedName("HA") 
  HA,
  /**
   * Hebrew
   */
  @com.google.gson.annotations.SerializedName("HE") 
  HE,
  /**
   * Herero
   */
  @com.google.gson.annotations.SerializedName("HZ") 
  HZ,
  /**
   * Hindi
   */
  @com.google.gson.annotations.SerializedName("HI") 
  HI,
  /**
   * Hiri Motu
   */
  @com.google.gson.annotations.SerializedName("HO") 
  HO,
  /**
   * Hungarian
   */
  @com.google.gson.annotations.SerializedName("HU") 
  HU,
  /**
   * Icelandic
   */
  @com.google.gson.annotations.SerializedName("IS") 
  IS,
  /**
   * Ido
   */
  @com.google.gson.annotations.SerializedName("IO") 
  IO,
  /**
   * Igbo
   */
  @com.google.gson.annotations.SerializedName("IG") 
  IG,
  /**
   * Indonesian
   */
  @com.google.gson.annotations.SerializedName("ID") 
  ID,
  /**
   * Interlingua (International Auxiliary Language Association)
   */
  @com.google.gson.annotations.SerializedName("IA") 
  IA,
  /**
   * Interlingue
   */
  @com.google.gson.annotations.SerializedName("IE") 
  IE,
  /**
   * Inuktitut
   */
  @com.google.gson.annotations.SerializedName("IU") 
  IU,
  /**
   * Inupiaq
   */
  @com.google.gson.annotations.SerializedName("IK") 
  IK,
  /**
   * Irish
   */
  @com.google.gson.annotations.SerializedName("GA") 
  GA,
  /**
   * Italian
   */
  @com.google.gson.annotations.SerializedName("IT") 
  IT,
  /**
   * Japanese
   */
  @com.google.gson.annotations.SerializedName("JA") 
  JA,
  /**
   * Javanese
   */
  @com.google.gson.annotations.SerializedName("JV") 
  JV,
  /**
   * Kannada
   */
  @com.google.gson.annotations.SerializedName("KN") 
  KN,
  /**
   * Kanuri
   */
  @com.google.gson.annotations.SerializedName("KR") 
  KR,
  /**
   * Kashmiri
   */
  @com.google.gson.annotations.SerializedName("KS") 
  KS,
  /**
   * Kazakh
   */
  @com.google.gson.annotations.SerializedName("KK") 
  KK,
  /**
   * Kinyarwanda
   */
  @com.google.gson.annotations.SerializedName("RW") 
  RW,
  /**
   * Komi
   */
  @com.google.gson.annotations.SerializedName("KV") 
  KV,
  /**
   * Kongo
   */
  @com.google.gson.annotations.SerializedName("KG") 
  KG,
  /**
   * Korean
   */
  @com.google.gson.annotations.SerializedName("KO") 
  KO,
  /**
   * Kwanyama, Kuanyama
   */
  @com.google.gson.annotations.SerializedName("KJ") 
  KJ,
  /**
   * Kurdish
   */
  @com.google.gson.annotations.SerializedName("KU") 
  KU,
  /**
   * Kyrgyz
   */
  @com.google.gson.annotations.SerializedName("KY") 
  KY,
  /**
   * Lao
   */
  @com.google.gson.annotations.SerializedName("LO") 
  LO,
  /**
   * Latin
   */
  @com.google.gson.annotations.SerializedName("LA") 
  LA,
  /**
   * Latvian
   */
  @com.google.gson.annotations.SerializedName("LV") 
  LV,
  /**
   * Letzeburgesch, Luxembourgish
   */
  @com.google.gson.annotations.SerializedName("LB") 
  LB,
  /**
   * Limburgish, Limburgan, Limburger
   */
  @com.google.gson.annotations.SerializedName("LI") 
  LI,
  /**
   * Lingala
   */
  @com.google.gson.annotations.SerializedName("LN") 
  LN,
  /**
   * Lithuanian
   */
  @com.google.gson.annotations.SerializedName("LT") 
  LT,
  /**
   * Luba-Katanga
   */
  @com.google.gson.annotations.SerializedName("LU") 
  LU,
  /**
   * Macedonian
   */
  @com.google.gson.annotations.SerializedName("MK") 
  MK,
  /**
   * Malagasy
   */
  @com.google.gson.annotations.SerializedName("MG") 
  MG,
  /**
   * Malay
   */
  @com.google.gson.annotations.SerializedName("MS") 
  MS,
  /**
   * Malayalam
   */
  @com.google.gson.annotations.SerializedName("ML") 
  ML,
  /**
   * Maltese
   */
  @com.google.gson.annotations.SerializedName("MT") 
  MT,
  /**
   * Manx
   */
  @com.google.gson.annotations.SerializedName("GV") 
  GV,
  /**
   * Maori
   */
  @com.google.gson.annotations.SerializedName("MI") 
  MI,
  /**
   * Marathi
   */
  @com.google.gson.annotations.SerializedName("MR") 
  MR,
  /**
   * Marshallese
   */
  @com.google.gson.annotations.SerializedName("MH") 
  MH,
  /**
   * Moldovan, Moldavian, Romanian
   */
  @com.google.gson.annotations.SerializedName("RO") 
  RO,
  /**
   * Mongolian
   */
  @com.google.gson.annotations.SerializedName("MN") 
  MN,
  /**
   * Nauru
   */
  @com.google.gson.annotations.SerializedName("NA") 
  NA,
  /**
   * Navajo, Navaho
   */
  @com.google.gson.annotations.SerializedName("NV") 
  NV,
  /**
   * Northern Ndebele
   */
  @com.google.gson.annotations.SerializedName("ND") 
  ND,
  /**
   * Ndonga
   */
  @com.google.gson.annotations.SerializedName("NG") 
  NG,
  /**
   * Nepali
   */
  @com.google.gson.annotations.SerializedName("NE") 
  NE,
  /**
   * Northern Sami
   */
  @com.google.gson.annotations.SerializedName("SE") 
  SE,
  /**
   * Norwegian
   */
  @com.google.gson.annotations.SerializedName("NO") 
  NO,
  /**
   * Norwegian Bokmål
   */
  @com.google.gson.annotations.SerializedName("NB") 
  NB,
  /**
   * Norwegian Nynorsk
   */
  @com.google.gson.annotations.SerializedName("NN") 
  NN,
  /**
   * Nuosu, Sichuan Yi
   */
  @com.google.gson.annotations.SerializedName("II") 
  II,
  /**
   * Occitan (post 1500)
   */
  @com.google.gson.annotations.SerializedName("OC") 
  OC,
  /**
   * Ojibwa
   */
  @com.google.gson.annotations.SerializedName("OJ") 
  OJ,
  /**
   * Oriya
   */
  @com.google.gson.annotations.SerializedName("OR") 
  OR,
  /**
   * Oromo
   */
  @com.google.gson.annotations.SerializedName("OM") 
  OM,
  /**
   * Ossetian, Ossetic
   */
  @com.google.gson.annotations.SerializedName("OS") 
  OS,
  /**
   * Pali
   */
  @com.google.gson.annotations.SerializedName("PI") 
  PI,
  /**
   * Panjabi, Punjabi
   */
  @com.google.gson.annotations.SerializedName("PA") 
  PA,
  /**
   * Pashto, Pushto
   */
  @com.google.gson.annotations.SerializedName("PS") 
  PS,
  /**
   * Persian
   */
  @com.google.gson.annotations.SerializedName("FA") 
  FA,
  /**
   * Polish
   */
  @com.google.gson.annotations.SerializedName("PL") 
  PL,
  /**
   * Portuguese
   */
  @com.google.gson.annotations.SerializedName("PT") 
  PT,
  /**
   * Quechua
   */
  @com.google.gson.annotations.SerializedName("QU") 
  QU,
  /**
   * Romansh
   */
  @com.google.gson.annotations.SerializedName("RM") 
  RM,
  /**
   * Rundi
   */
  @com.google.gson.annotations.SerializedName("RN") 
  RN,
  /**
   * Russian
   */
  @com.google.gson.annotations.SerializedName("RU") 
  RU,
  /**
   * Samoan
   */
  @com.google.gson.annotations.SerializedName("SM") 
  SM,
  /**
   * Sango
   */
  @com.google.gson.annotations.SerializedName("SG") 
  SG,
  /**
   * Sanskrit
   */
  @com.google.gson.annotations.SerializedName("SA") 
  SA,
  /**
   * Sardinian
   */
  @com.google.gson.annotations.SerializedName("SC") 
  SC,
  /**
   * Serbian
   */
  @com.google.gson.annotations.SerializedName("SR") 
  SR,
  /**
   * Shona
   */
  @com.google.gson.annotations.SerializedName("SN") 
  SN,
  /**
   * Sindhi
   */
  @com.google.gson.annotations.SerializedName("SD") 
  SD,
  /**
   * Sinhala, Sinhalese
   */
  @com.google.gson.annotations.SerializedName("SI") 
  SI,
  /**
   * Slovak
   */
  @com.google.gson.annotations.SerializedName("SK") 
  SK,
  /**
   * Slovenian
   */
  @com.google.gson.annotations.SerializedName("SL") 
  SL,
  /**
   * Somali
   */
  @com.google.gson.annotations.SerializedName("SO") 
  SO,
  /**
   * Sotho, Southern
   */
  @com.google.gson.annotations.SerializedName("ST") 
  ST,
  /**
   * South Ndebele
   */
  @com.google.gson.annotations.SerializedName("NR") 
  NR,
  /**
   * Spanish, Castilian
   */
  @com.google.gson.annotations.SerializedName("ES") 
  ES,
  /**
   * Sundanese
   */
  @com.google.gson.annotations.SerializedName("SU") 
  SU,
  /**
   * Swahili
   */
  @com.google.gson.annotations.SerializedName("SW") 
  SW,
  /**
   * Swati
   */
  @com.google.gson.annotations.SerializedName("SS") 
  SS,
  /**
   * Swedish
   */
  @com.google.gson.annotations.SerializedName("SV") 
  SV,
  /**
   * Tagalog
   */
  @com.google.gson.annotations.SerializedName("TL") 
  TL,
  /**
   * Tahitian
   */
  @com.google.gson.annotations.SerializedName("TY") 
  TY,
  /**
   * Tajik
   */
  @com.google.gson.annotations.SerializedName("TG") 
  TG,
  /**
   * Tamil
   */
  @com.google.gson.annotations.SerializedName("TA") 
  TA,
  /**
   * Tatar
   */
  @com.google.gson.annotations.SerializedName("TT") 
  TT,
  /**
   * Telugu
   */
  @com.google.gson.annotations.SerializedName("TE") 
  TE,
  /**
   * Thai
   */
  @com.google.gson.annotations.SerializedName("TH") 
  TH,
  /**
   * Tibetan
   */
  @com.google.gson.annotations.SerializedName("BO") 
  BO,
  /**
   * Tigrinya
   */
  @com.google.gson.annotations.SerializedName("TI") 
  TI,
  /**
   * Tonga (Tonga Islands)
   */
  @com.google.gson.annotations.SerializedName("TO") 
  TO,
  /**
   * Tsonga
   */
  @com.google.gson.annotations.SerializedName("TS") 
  TS,
  /**
   * Tswana
   */
  @com.google.gson.annotations.SerializedName("TN") 
  TN,
  /**
   * Turkish
   */
  @com.google.gson.annotations.SerializedName("TR") 
  TR,
  /**
   * Turkmen
   */
  @com.google.gson.annotations.SerializedName("TK") 
  TK,
  /**
   * Twi
   */
  @com.google.gson.annotations.SerializedName("TW") 
  TW,
  /**
   * Uighur, Uyghur
   */
  @com.google.gson.annotations.SerializedName("UG") 
  UG,
  /**
   * Ukrainian
   */
  @com.google.gson.annotations.SerializedName("UK") 
  UK,
  /**
   * Urdu
   */
  @com.google.gson.annotations.SerializedName("UR") 
  UR,
  /**
   * Uzbek
   */
  @com.google.gson.annotations.SerializedName("UZ") 
  UZ,
  /**
   * Venda
   */
  @com.google.gson.annotations.SerializedName("VE") 
  VE,
  /**
   * Vietnamese
   */
  @com.google.gson.annotations.SerializedName("VI") 
  VI,
  /**
   * Volap_k
   */
  @com.google.gson.annotations.SerializedName("VO") 
  VO,
  /**
   * Walloon
   */
  @com.google.gson.annotations.SerializedName("WA") 
  WA,
  /**
   * Welsh
   */
  @com.google.gson.annotations.SerializedName("CY") 
  CY,
  /**
   * Western Frisian
   */
  @com.google.gson.annotations.SerializedName("FY") 
  FY,
  /**
   * Wolof
   */
  @com.google.gson.annotations.SerializedName("WO") 
  WO,
  /**
   * Xhosa
   */
  @com.google.gson.annotations.SerializedName("XH") 
  XH,
  /**
   * Yiddish
   */
  @com.google.gson.annotations.SerializedName("YI") 
  YI,
  /**
   * Yoruba
   */
  @com.google.gson.annotations.SerializedName("YO") 
  YO,
  /**
   * Zhuang, Chuang
   */
  @com.google.gson.annotations.SerializedName("ZA") 
  ZA,
  /**
   * Zulu
   */
  @com.google.gson.annotations.SerializedName("ZU") 
  ZU;
  @java.lang.Override
  public java.lang.String toString() {
    com.google.gson.annotations.SerializedName sn = this.getClass().getDeclaredAnnotation(com.google.gson.annotations.SerializedName.class);
    if (sn == null)
      return name();
    return sn.value();
  }
}
