/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.maven.consulkv;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;

public class ConfigLoader {
    private String baseDir;
    private Log log;

    public ConfigLoader(String baseDir, Log log) {
        this.baseDir = baseDir;
        this.log = log;
    }

    public Properties loadProperties(String folder) {
        Properties allProperties = new Properties();
        try {
            Files.list(Paths.get(this.baseDir, folder)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                Properties props = new Properties();
                try {
                    props.load(Files.newInputStream(p, new OpenOption[0]));
                }
                catch (IOException e) {
                    this.log.warn((CharSequence)("Failed to load properties from " + p.toString()));
                }
                allProperties.putAll((Map<?, ?>)props);
            });
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Failed to walk " + Paths.get(this.baseDir, folder)));
        }
        return allProperties;
    }
}

