/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.maven.consulkv;

import ch.carve.maven.consulkv.ConfigLoader;
import com.ecwid.consul.v1.ConsulClient;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="configure", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ConfigureMojo
extends AbstractMojo {
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="prefix", defaultValue="")
    private String prefix;
    @Parameter(property="config-dirs", defaultValue="src/main/resources")
    private List<String> configDirs;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("start putting config to consul at: " + this.url));
        ConfigLoader loader = new ConfigLoader(this.project.getBasedir().getAbsolutePath(), this.getLog());
        this.configDirs.forEach(configDir -> {
            Properties properties = loader.loadProperties((String)configDir);
            String consulPrefix = this.prefix == null ? "" : this.prefix + "/";
            ConsulClient consul = new ConsulClient(this.url);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                consul.setKVValue(consulPrefix + k, (String)v);
                this.getLog().info((CharSequence)("Put " + consulPrefix + k + ":" + v));
            }));
        });
    }
}

