/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.maven.consulkv;

import ch.carve.maven.consulkv.ConfigLoader;
import com.ecwid.consul.v1.ConsulClient;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="configure", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class ConfigureMojo
extends AbstractMojo {
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="prefix", defaultValue="")
    private String prefix;
    @Parameter(property="config-dirs", defaultValue="src/main/resources")
    private List<String> configDirs;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("start putting config to consul at: " + this.url));
        ConfigLoader loader = new ConfigLoader(this.project.getBasedir().getAbsolutePath(), arg_0 -> ((Log)this.getLog()).warn(arg_0));
        ConsulClient consul = new ConsulClient(this.url);
        this.configDirs.forEach(configDir -> {
            Properties properties = loader.loadProperties((String)configDir);
            ConfigureMojo.configureConsul(consul, properties, this.prefix, arg_0 -> ((Log)this.getLog()).info(arg_0));
        });
    }

    public static void configureConsul(ConsulClient consul, Properties properties, String prefix, Consumer<CharSequence> log) {
        String consulPrefix = prefix == null ? "" : prefix + "/";
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            consul.setKVValue(consulPrefix + k, (String)v);
            log.accept("Put " + consulPrefix + k + ":" + v);
        }));
    }
}

