/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ACLAugment;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import org.apache.commons.collections4.Equator;

public class ACLAugmentSatisfyEquator
implements Equator<ACLAugment> {
    @Override
    public boolean equate(ACLAugment o1, ACLAugment o2) {
        boolean check_id;
        boolean check_scheme;
        boolean check_perms;
        boolean bl = check_perms = (o1.getPerms() & o2.getPerms()) == o1.getPerms();
        if (o2.getScheme().equals("world") && o2.getId().equals("anyone")) {
            check_scheme = true;
            check_id = true;
        } else if (o1.getScheme().equals("ip") && o2.getScheme().equals("ip")) {
            check_scheme = true;
            IPAddressString addrStringOperand2 = new IPAddressString(o2.getId());
            try {
                IPAddress addrOperand2 = addrStringOperand2.getAddress();
                Integer prefix = addrOperand2.getNetworkPrefixLength();
                if (prefix == null) {
                    check_id = o1.getId().equals(o2.getId());
                }
                IPAddressString addrStringOperand1 = new IPAddressString(o1.getId());
                IPAddress addrOperand1 = addrStringOperand1.toAddress();
                check_id = addrOperand2.contains(addrOperand1);
            }
            catch (AddressStringException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            check_scheme = o1.getScheme().equals(o2.getScheme());
            check_id = o1.getId().equals(o2.getId());
        }
        return check_scheme && check_id && check_perms;
    }

    @Override
    public int hash(ACLAugment o1) {
        return o1.hashCode();
    }
}

